/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteWeakHashMap;
import java.util.Map;

public class CachingSingleObjectSizer
implements SingleObjectSizer {
    private final Map<Class, Long> sizeCache = new CopyOnWriteWeakHashMap<Class, Long>();
    private final SingleObjectSizer wrappedSizer;

    public CachingSingleObjectSizer(SingleObjectSizer sizer) {
        this.wrappedSizer = sizer;
    }

    @Override
    public long sizeof(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return this.wrappedSizer.sizeof(object);
        }
        Long size = this.sizeCache.get(clazz);
        if (size != null) {
            return size;
        }
        size = this.wrappedSizer.sizeof(object);
        this.sizeCache.put(clazz, size);
        return size;
    }
}

