/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.process.signal.Signal;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gemfire.internal.shared.NativeErrorException;
import com.gemstone.gemfire.internal.shared.OSType;
import com.gemstone.gemfire.internal.shared.TCPSocketOptions;
import com.sun.jna.Callback;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NativeCallsJNAImpl {
    private static final NativeCalls instance = NativeCallsJNAImpl.getImplInstance();

    private NativeCallsJNAImpl() {
    }

    private static final NativeCalls getImplInstance() {
        if (Platform.isLinux()) {
            return new LinuxNativeCalls();
        }
        if (Platform.isWindows()) {
            return new WinNativeCalls();
        }
        if (Platform.isSolaris()) {
            return new SolarisNativeCalls();
        }
        if (Platform.isMac()) {
            return new MacOSXNativeCalls();
        }
        if (Platform.isFreeBSD()) {
            return new FreeBSDNativeCalls();
        }
        return new POSIXNativeCalls();
    }

    public static NativeCalls getInstance() {
        return instance;
    }

    private static final class WinNativeCalls
    extends NativeCalls {
        static final int WSAENOPROTOOPT = 10042;
        static final int SIO_KEEPALIVE_VALS = -1744830460;
        private static final Map<String, String> javaEnv;

        private WinNativeCalls() {
        }

        public static native int WSAIoctl(NativeLong var0, int var1, TcpKeepAlive var2, int var3, Pointer var4, int var5, IntByReference var6, Pointer var7, Pointer var8) throws LastErrorException;

        @Override
        public OSType getOSType() {
            return OSType.WIN;
        }

        @Override
        public synchronized void setEnvironment(String name, String value) {
            if (name == null) {
                throw new UnsupportedOperationException("setEnvironment() for name=NULL");
            }
            boolean res = false;
            NativeErrorException cause = null;
            try {
                res = Kernel32.SetEnvironmentVariableA(name, value);
            }
            catch (LastErrorException le) {
                if (value == null && le.getErrorCode() == 203) {
                    res = true;
                }
                cause = new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
            }
            if (!res) {
                throw new IllegalArgumentException("setEnvironment: given name=" + name + " (value=" + value + ')', cause);
            }
            if (javaEnv != null) {
                if (value != null) {
                    javaEnv.put(name, value);
                } else {
                    javaEnv.remove(name);
                }
            }
        }

        @Override
        public synchronized String getEnvironment(String name) {
            if (name == null) {
                throw new UnsupportedOperationException("getEnvironment() for name=NULL");
            }
            int psize = Kernel32.GetEnvironmentVariableA(name, null, 0);
            if (psize > 0) {
                do {
                    byte[] result;
                    if ((psize = Kernel32.GetEnvironmentVariableA(name, result = new byte[psize], psize)) != result.length - 1) continue;
                    return new String(result, 0, psize);
                } while (psize > 0);
                return null;
            }
            return null;
        }

        @Override
        public int getProcessId() {
            return Kernel32.GetCurrentProcessId();
        }

        @Override
        public boolean isProcessActive(int processId) {
            try {
                long hval;
                Pointer procHandle = Kernel32.OpenProcess(1024, false, processId);
                if (procHandle == null || (hval = Pointer.nativeValue((Pointer)procHandle)) == -1L || hval == 0L) {
                    return false;
                }
                IntByReference status = new IntByReference();
                boolean result = Kernel32.GetExitCodeProcess(procHandle, status) && status != null && status.getValue() == 259;
                Kernel32.CloseHandle(procHandle);
                return result;
            }
            catch (LastErrorException le) {
                return false;
            }
        }

        @Override
        public boolean killProcess(int processId) {
            try {
                long hval;
                Pointer procHandle = Kernel32.OpenProcess(1, false, processId);
                if (procHandle == null || (hval = Pointer.nativeValue((Pointer)procHandle)) == -1L || hval == 0L) {
                    return false;
                }
                boolean result = Kernel32.TerminateProcess(procHandle, -1);
                Kernel32.CloseHandle(procHandle);
                return result;
            }
            catch (LastErrorException le) {
                return false;
            }
        }

        @Override
        public void daemonize(NativeCalls.RehashServerOnSIGHUP callback) throws UnsupportedOperationException, IllegalStateException {
            throw new IllegalStateException("daemonize() not applicable for Windows platform");
        }

        @Override
        public Map<TCPSocketOptions, Throwable> setSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
            TcpKeepAlive optValue = new TcpKeepAlive();
            int optSize = 12;
            TCPSocketOptions errorOpt = null;
            Exception error = null;
            block7: for (Map.Entry<TCPSocketOptions, Object> e : optValueMap.entrySet()) {
                TCPSocketOptions opt = e.getKey();
                Object value = e.getValue();
                if (value == null || !(value instanceof Integer)) {
                    throw new IllegalArgumentException("bad argument type " + (value != null ? value.getClass().getName() : "NULL") + " for " + (Object)((Object)opt));
                }
                switch (opt) {
                    case OPT_KEEPIDLE: {
                        optValue.onoff = 1;
                        optValue.keepalivetime = (Integer)value * 1000;
                        continue block7;
                    }
                    case OPT_KEEPINTVL: {
                        optValue.onoff = 1;
                        optValue.keepaliveinterval = (Integer)value * 1000;
                        continue block7;
                    }
                    case OPT_KEEPCNT: {
                        errorOpt = opt;
                        error = new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(opt));
                        continue block7;
                    }
                }
                throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
            }
            int sockfd = this.getSocketKernelDescriptor(sock, sockStream);
            IntByReference nBytes = new IntByReference(0);
            try {
                if (WinNativeCalls.WSAIoctl(new NativeLong((long)sockfd), -1744830460, optValue, 12, null, 0, nBytes, null, null) != 0) {
                    errorOpt = TCPSocketOptions.OPT_KEEPIDLE;
                    error = new SocketException((Object)((Object)this.getOSType()) + ": error setting options: " + optValueMap);
                }
            }
            catch (LastErrorException le) {
                errorOpt = TCPSocketOptions.OPT_KEEPIDLE;
                if (le.getErrorCode() == 10042) {
                    error = new UnsupportedOperationException(this.getUnsupportedSocketOptionMessage(errorOpt), new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause()));
                }
                SocketException se = new SocketException((Object)((Object)this.getOSType()) + ": failed to set options: " + optValueMap);
                se.initCause(le);
                error = se;
            }
            return errorOpt != null ? Collections.singletonMap(errorOpt, error) : null;
        }

        static {
            Native.register((String)"Ws2_32");
            javaEnv = WinNativeCalls.getModifiableJavaEnvWIN();
        }

        private static final class Kernel32 {
            static final int PROCESS_QUERY_INFORMATION = 1024;
            static final int PROCESS_TERMINATE = 1;
            static final int STILL_ACTIVE = 259;
            static final int INVALID_HANDLE = -1;

            private Kernel32() {
            }

            public static native boolean SetEnvironmentVariableA(String var0, String var1) throws LastErrorException;

            public static native int GetEnvironmentVariableA(String var0, byte[] var1, int var2);

            public static native int GetCurrentProcessId();

            public static native Pointer OpenProcess(int var0, boolean var1, int var2) throws LastErrorException;

            public static native boolean TerminateProcess(Pointer var0, int var1) throws LastErrorException;

            public static native boolean GetExitCodeProcess(Pointer var0, IntByReference var1) throws LastErrorException;

            public static native boolean CloseHandle(Pointer var0) throws LastErrorException;

            static {
                HashMap<String, Integer> kernel32Options = new HashMap<String, Integer>();
                kernel32Options.put("calling-convention", 1);
                kernel32Options.put("function-mapper", (Integer)StdCallLibrary.FUNCTION_MAPPER);
                NativeLibrary kernel32Lib = NativeLibrary.getInstance((String)"kernel32", kernel32Options);
                Native.register((NativeLibrary)kernel32Lib);
            }
        }

        public static final class TcpKeepAlive
        extends Structure {
            public int onoff;
            public int keepalivetime;
            public int keepaliveinterval;

            protected List<?> getFieldOrder() {
                return Arrays.asList("onoff", "keepalivetime", "keepaliveinterval");
            }
        }
    }

    private static class FreeBSDNativeCalls
    extends POSIXNativeCalls {
        static final int OPT_TCP_KEEPALIVE = 256;
        static final int OPT_TCP_KEEPINTVL = 512;
        static final int OPT_TCP_KEEPCNT = 1024;
        static final int ENOPROTOOPT = 42;

        private FreeBSDNativeCalls() {
        }

        @Override
        public OSType getOSType() {
            return OSType.FREEBSD;
        }

        @Override
        protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
            switch (opt) {
                case OPT_KEEPIDLE: {
                    return 256;
                }
                case OPT_KEEPINTVL: {
                    return 512;
                }
                case OPT_KEEPCNT: {
                    return 1024;
                }
            }
            throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
        }

        @Override
        protected boolean isNoProtocolOptionCode(int errno) {
            return errno == 42;
        }
    }

    private static class MacOSXNativeCalls
    extends POSIXNativeCalls {
        static final int OPT_TCP_KEEPALIVE = 16;
        static final int ENOPROTOOPT = 42;

        private MacOSXNativeCalls() {
        }

        @Override
        public OSType getOSType() {
            return OSType.MACOSX;
        }

        @Override
        protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
            switch (opt) {
                case OPT_KEEPIDLE: {
                    return 16;
                }
                case OPT_KEEPINTVL: 
                case OPT_KEEPCNT: {
                    return Integer.MIN_VALUE;
                }
            }
            throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
        }

        @Override
        protected boolean isNoProtocolOptionCode(int errno) {
            return errno == 42;
        }
    }

    private static class SolarisNativeCalls
    extends POSIXNativeCalls {
        static final int OPT_TCP_KEEPALIVE_THRESHOLD = 22;
        static final int OPT_TCP_KEEPALIVE_ABORT_THRESHOLD = 23;
        static final int ENOPROTOOPT = 99;

        private SolarisNativeCalls() {
        }

        @Override
        public OSType getOSType() {
            return OSType.SOLARIS;
        }

        @Override
        protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
            switch (opt) {
                case OPT_KEEPIDLE: {
                    return 22;
                }
                case OPT_KEEPINTVL: 
                case OPT_KEEPCNT: {
                    return Integer.MIN_VALUE;
                }
            }
            throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
        }

        @Override
        protected int setPlatformSocketOption(int sockfd, int level, int optName, TCPSocketOptions opt, Integer optVal, int optSize) throws NativeErrorException {
            try {
                switch (optName) {
                    case 22: {
                        IntByReference timeout = new IntByReference(optVal * 1000);
                        int result = SolarisNativeCalls.setsockopt(sockfd, level, optName, timeout, optSize);
                        if (result == 0) {
                            return SolarisNativeCalls.setsockopt(sockfd, level, 23, timeout, optSize);
                        }
                        return result;
                    }
                }
                throw new UnsupportedOperationException("unsupported option " + (Object)((Object)opt));
            }
            catch (LastErrorException le) {
                throw new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
            }
        }

        @Override
        protected boolean isNoProtocolOptionCode(int errno) {
            return errno == 99;
        }

        static {
            Native.register((String)"nsl");
            Native.register((String)"socket");
        }
    }

    private static class LinuxNativeCalls
    extends POSIXNativeCalls {
        static final int OPT_TCP_KEEPIDLE = 4;
        static final int OPT_TCP_KEEPINTVL = 5;
        static final int OPT_TCP_KEEPCNT = 6;
        static final int ENOPROTOOPT = 92;
        static final int ENOPROTOOPT_ALPHA = 42;
        static final int ENOPROTOOPT_MIPS = 99;
        static final int ENOPROTOOPT_PARISC = 220;
        private ThreadLocal<Structure> tSpecs = new ThreadLocal();
        private static boolean isStatFSEnabled;
        public static final String[] FallocateFileSystems;

        private LinuxNativeCalls() {
        }

        public static native int posix_fallocate64(int var0, long var1, long var3);

        public static native int creat64(String var0, int var1) throws LastErrorException;

        @Override
        public OSType getOSType() {
            return OSType.LINUX;
        }

        @Override
        protected int getPlatformOption(TCPSocketOptions opt) throws UnsupportedOperationException {
            switch (opt) {
                case OPT_KEEPIDLE: {
                    return 4;
                }
                case OPT_KEEPINTVL: {
                    return 5;
                }
                case OPT_KEEPCNT: {
                    return 6;
                }
            }
            throw new UnsupportedOperationException("unknown option " + (Object)((Object)opt));
        }

        @Override
        protected boolean isNoProtocolOptionCode(int errno) {
            switch (errno) {
                case 92: {
                    return true;
                }
                case 42: {
                    return true;
                }
                case 99: {
                    return true;
                }
                case 220: {
                    return true;
                }
            }
            return false;
        }

        public String getFileStoreType(String path) {
            Path currentPath;
            File diskFile = new File(path);
            if (!diskFile.exists()) {
                diskFile = diskFile.getParentFile();
            }
            if ((currentPath = diskFile.toPath()).isAbsolute() && Files.exists(currentPath, new LinkOption[0])) {
                try {
                    FileStore store = Files.getFileStore(currentPath);
                    return store.type();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isOnLocalFileSystem(String path) {
            LogWriter logger = InternalDistributedSystem.getAnyInstance() != null ? InternalDistributedSystem.getAnyInstance().getLogWriter() : null;
            if (!isStatFSEnabled) {
                return false;
            }
            int numTries = 10;
            for (int i = 1; i <= 10; ++i) {
                try {
                    if (Platform.is64Bit()) {
                        StatFS64 stat = new StatFS64();
                        StatFS64.statfs(path, stat);
                        return stat.isTypeLocal();
                    }
                    StatFS stat = new StatFS();
                    StatFS.statfs(path, stat);
                    return stat.isTypeLocal();
                }
                catch (LastErrorException le) {
                    if (logger == null || !logger.fineEnabled()) continue;
                    logger.fine("DEBUG isOnLocalFileSystem got ex = " + (Object)((Object)le) + " msg = " + le.getMessage());
                    continue;
                }
            }
            return false;
        }

        @Override
        protected boolean hasFallocate(String path) {
            String fstype = this.getFileStoreType(path);
            for (String type : FallocateFileSystems) {
                if (!type.equalsIgnoreCase(fstype)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int createFD(String path, int flags) throws LastErrorException {
            return LinuxNativeCalls.creat64(path, flags);
        }

        @Override
        protected void fallocateFD(int fd, long offset, long len) throws LastErrorException {
            int errno = LinuxNativeCalls.posix_fallocate64(fd, offset, len);
            if (errno != 0) {
                throw new LastErrorException(errno);
            }
        }

        static {
            Native.register((String)"c");
            if (Platform.is64Bit()) {
                StatFS64.dummy();
            } else {
                StatFS.dummy();
            }
            FallocateFileSystems = new String[]{"ext4", "xfs", "btrfs", "ocfs2"};
        }

        public static class StatFS64
        extends Structure {
            public long f_type;
            public long f_bsize;
            public long f_blocks;
            public long f_bfree;
            public long f_bavail;
            public long f_files;
            public long f_ffree;
            public FSIDIntArr2 f_fsid;
            public long f_namelen;
            public long f_frsize;
            public FSPARELongArr5 f_spare;
            private static long[] REMOTE_TYPES = new long[]{4283649346L, 1937076805L, 22092L, 26985L, 20859L, 16914836L};

            public static native int statfs(String var0, StatFS64 var1) throws LastErrorException;

            protected List getFieldOrder() {
                return Arrays.asList("f_type", "f_bsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_fsid", "f_namelen", "f_frsize", "f_spare");
            }

            public boolean isTypeLocal() {
                for (int i = 0; i < REMOTE_TYPES.length; ++i) {
                    if (REMOTE_TYPES[i] != this.f_type) continue;
                    return false;
                }
                return true;
            }

            public static void dummy() {
            }

            static {
                try {
                    Native.register((String)"rt");
                    StatFS64 struct = new StatFS64();
                    int ret = StatFS64.statfs(".", struct);
                    if (ret == 0) {
                        isStatFSEnabled = true;
                    } else {
                        isStatFSEnabled = false;
                    }
                }
                catch (Throwable t) {
                    System.out.println("got error t: " + t.getMessage());
                    t.printStackTrace();
                    isStatFSEnabled = false;
                }
            }
        }

        public static class FSPARELongArr5
        extends Structure {
            public long[] fspare = new long[5];

            protected List getFieldOrder() {
                return Arrays.asList("fspare");
            }
        }

        public static class StatFS
        extends Structure {
            public int f_type;
            public int f_bsize;
            public int f_blocks;
            public int f_bfree;
            public int f_bavail;
            public int f_files;
            public int f_ffree;
            public FSIDIntArr2 f_fsid;
            public int f_namelen;
            public int f_frsize;
            public FSPAREIntArr5 f_spare;
            private static int[] REMOTE_TYPES;

            public static native int statfs(String var0, StatFS var1) throws LastErrorException;

            protected List getFieldOrder() {
                return Arrays.asList("f_type", "f_bsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_fsid", "f_namelen", "f_frsize", "f_spare");
            }

            public boolean isTypeLocal() {
                for (int i = 0; i < REMOTE_TYPES.length; ++i) {
                    if (REMOTE_TYPES[i] != this.f_type) continue;
                    return false;
                }
                return true;
            }

            public static void dummy() {
            }

            static {
                try {
                    Native.register((String)"rt");
                    StatFS struct = new StatFS();
                    int ret = StatFS.statfs(".", struct);
                    if (ret == 0) {
                        isStatFSEnabled = true;
                    } else {
                        isStatFSEnabled = false;
                    }
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    isStatFSEnabled = false;
                }
                REMOTE_TYPES = new int[]{1937076805, 22092, 26985, 20859, 16914836};
            }
        }

        public static class FSPAREIntArr5
        extends Structure {
            public int[] fspare = new int[5];

            protected List getFieldOrder() {
                return Arrays.asList("fspare");
            }
        }

        public static class FSIDIntArr2
        extends Structure {
            public int[] fsid = new int[2];

            protected List getFieldOrder() {
                return Arrays.asList("fsid");
            }
        }
    }

    private static class POSIXNativeCalls
    extends NativeCalls {
        static final int EPERM = 1;
        static final int ENOSPC = 28;
        static final Map<String, String> javaEnv;
        SignalHandler hupHandler;
        NativeCalls.RehashServerOnSIGHUP rehashCallback;

        private POSIXNativeCalls() {
        }

        public static native int setenv(String var0, String var1, int var2) throws LastErrorException;

        public static native int unsetenv(String var0) throws LastErrorException;

        public static native String getenv(String var0);

        public static native int getpid();

        public static native int kill(int var0, int var1) throws LastErrorException;

        public static native int setsid() throws LastErrorException;

        public static native int umask(int var0);

        public static native int signal(int var0, SignalHandler var1);

        public static native int setsockopt(int var0, int var1, int var2, IntByReference var3, int var4) throws LastErrorException;

        public static native int close(int var0) throws LastErrorException;

        public static native int isatty(int var0) throws LastErrorException;

        @Override
        public OSType getOSType() {
            return OSType.GENERIC_POSIX;
        }

        @Override
        public synchronized void setEnvironment(String name, String value) {
            if (name == null) {
                throw new UnsupportedOperationException("setEnvironment() for name=NULL");
            }
            int res = -1;
            NativeErrorException cause = null;
            try {
                res = value != null ? POSIXNativeCalls.setenv(name, value, 1) : POSIXNativeCalls.unsetenv(name);
            }
            catch (LastErrorException le) {
                cause = new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
            }
            if (res != 0) {
                throw new IllegalArgumentException("setEnvironment: given name=" + name + " (value=" + value + ')', cause);
            }
            if (javaEnv != null) {
                if (value != null) {
                    javaEnv.put(name, value);
                } else {
                    javaEnv.remove(name);
                }
            }
        }

        @Override
        public synchronized String getEnvironment(String name) {
            if (name == null) {
                throw new UnsupportedOperationException("getEnvironment() for name=NULL");
            }
            return POSIXNativeCalls.getenv(name);
        }

        @Override
        public int getProcessId() {
            return POSIXNativeCalls.getpid();
        }

        @Override
        public boolean isProcessActive(int processId) {
            try {
                return POSIXNativeCalls.kill(processId, 0) == 0;
            }
            catch (LastErrorException le) {
                return le.getErrorCode() == 1;
            }
        }

        @Override
        public boolean killProcess(int processId) {
            try {
                return POSIXNativeCalls.kill(processId, 9) == 0;
            }
            catch (LastErrorException le) {
                return false;
            }
        }

        @Override
        public void daemonize(NativeCalls.RehashServerOnSIGHUP callback) throws UnsupportedOperationException {
            UnsupportedOperationException err;
            block4: {
                err = null;
                try {
                    POSIXNativeCalls.setsid();
                }
                catch (LastErrorException le) {
                    if (le.getErrorCode() == 1) break block4;
                    err = new UnsupportedOperationException("Failed in setsid() in daemonize() due to " + le.getMessage() + " (errno=" + le.getErrorCode() + ')');
                }
            }
            int newMask = 18;
            int oldMask = POSIXNativeCalls.umask(18);
            if ((oldMask & 0x3F) > 18) {
                POSIXNativeCalls.umask(oldMask);
            }
            this.rehashCallback = callback;
            this.hupHandler = new SignalHandler(){

                @Override
                public void callback(int signum) {
                    NativeCalls.RehashServerOnSIGHUP rehashCb = rehashCallback;
                    if (signum == Signal.SIGHUP.getNumber() && rehashCb != null) {
                        rehashCb.rehash();
                    }
                }
            };
            POSIXNativeCalls.signal(Signal.SIGHUP.getNumber(), this.hupHandler);
            POSIXNativeCalls.signal(Signal.SIGCHLD.getNumber(), this.hupHandler);
            POSIXNativeCalls.signal(Signal.SIGINT.getNumber(), this.hupHandler);
            if (err != null) {
                throw err;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preBlow(String path, long maxSize, boolean preAllocate) throws IOException {
            LogWriter logger = InternalDistributedSystem.getAnyInstance() != null ? InternalDistributedSystem.getAnyInstance().getLogWriter() : null;
            if (logger != null && logger.fineEnabled()) {
                logger.fine("DEBUG preBlow called for path = " + path);
            }
            if (!preAllocate || !this.hasFallocate(path)) {
                super.preBlow(path, maxSize, preAllocate);
                if (logger != null && logger.fineEnabled()) {
                    logger.fine("DEBUG preBlow super.preBlow 1 called for path = " + path);
                }
                return;
            }
            int fd = -1;
            boolean unknownError = false;
            try {
                fd = this.createFD(path, 420);
                if (!this.isOnLocalFileSystem(path)) {
                    super.preBlow(path, maxSize, preAllocate);
                    if (logger != null && logger.fineEnabled()) {
                        logger.fine("DEBUG preBlow super.preBlow 2 called as path = " + path + " not on local file system");
                    }
                    if (DiskStoreImpl.TEST_NO_FALLOC_DIRS != null) {
                        DiskStoreImpl.TEST_NO_FALLOC_DIRS.add(path);
                    }
                    return;
                }
                this.fallocateFD(fd, 0L, maxSize);
                if (DiskStoreImpl.TEST_CHK_FALLOC_DIRS != null) {
                    DiskStoreImpl.TEST_CHK_FALLOC_DIRS.add(path);
                }
                if (logger != null && logger.fineEnabled()) {
                    logger.fine("DEBUG preBlow posix_fallocate called for path = " + path + " and ret = 0 maxsize = " + maxSize);
                }
            }
            catch (LastErrorException le) {
                if (logger != null && logger.fineEnabled()) {
                    logger.fine("DEBUG preBlow posix_fallocate called for path = " + path + " and ret = " + le.getErrorCode() + " maxsize = " + maxSize);
                }
                if (le.getErrorCode() == 28) {
                    unknownError = false;
                    throw new IOException("Not enough space left on device");
                }
                unknownError = true;
            }
            finally {
                if (fd >= 0) {
                    try {
                        POSIXNativeCalls.close(fd);
                    }
                    catch (Exception exception) {}
                }
                if (unknownError) {
                    super.preBlow(path, maxSize, preAllocate);
                    if (logger != null && logger.infoEnabled()) {
                        logger.fine("DEBUG preBlow super.preBlow 3 called for path = " + path);
                    }
                }
            }
        }

        protected boolean hasFallocate(String path) {
            return false;
        }

        protected int createFD(String path, int flags) throws LastErrorException {
            throw new UnsupportedOperationException("not expected to be invoked");
        }

        protected void fallocateFD(int fd, long offset, long len) throws LastErrorException {
            throw new UnsupportedOperationException("not expected to be invoked");
        }

        @Override
        public Map<TCPSocketOptions, Throwable> setSocketOptions(Socket sock, InputStream sockStream, Map<TCPSocketOptions, Object> optValueMap) throws UnsupportedOperationException {
            return super.setGenericSocketOptions(sock, sockStream, optValueMap);
        }

        @Override
        protected int setPlatformSocketOption(int sockfd, int level, int optName, TCPSocketOptions opt, Integer optVal, int optSize) throws NativeErrorException {
            try {
                return POSIXNativeCalls.setsockopt(sockfd, level, optName, new IntByReference(optVal.intValue()), optSize);
            }
            catch (LastErrorException le) {
                throw new NativeErrorException(le.getMessage(), le.getErrorCode(), le.getCause());
            }
        }

        @Override
        public boolean isTTY() {
            try {
                return POSIXNativeCalls.isatty(0) == 1;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't find tty impl. ", e);
            }
        }

        static {
            Native.register((String)"c");
            javaEnv = POSIXNativeCalls.getModifiableJavaEnv();
        }

        static interface SignalHandler
        extends Callback {
            public void callback(int var1);
        }
    }
}

