/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.sequencelog.io;

import com.gemstone.gemfire.internal.sequencelog.Transition;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.regex.Pattern;

public class OutputStreamAppender {
    private IdentityHashMap<Object, Integer> writtenObjects = new IdentityHashMap();
    private HashMap<String, Integer> writtenStrings = new HashMap();
    private DataOutputStream outputStream;
    private int nextInt = 0;
    public static final byte EDGE_RECORD = 1;
    public static final byte STRING_RECORD = 2;

    public OutputStreamAppender(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public OutputStreamAppender(OutputStream out) throws FileNotFoundException {
        this.outputStream = new DataOutputStream(new BufferedOutputStream(out, 256));
        this.writtenObjects.put(null, -1);
    }

    public void write(Transition edge) throws IOException {
        byte graphType = edge.getType().getId();
        String stateName = edge.getState() == null ? "null" : edge.getState().toString();
        long timestamp = edge.getTimestamp();
        int edgeId = this.canonalize(edge.getEdgeName());
        int source = this.canonalize(edge.getSource());
        int dest = this.canonalize(edge.getDest());
        this.outputStream.write(1);
        this.outputStream.writeLong(timestamp);
        this.outputStream.write(graphType);
        this.writeGraphName(edge.getGraphName());
        this.outputStream.writeUTF(stateName);
        this.outputStream.writeInt(edgeId);
        this.outputStream.writeInt(source);
        this.outputStream.writeInt(dest);
        this.outputStream.flush();
    }

    private void writeGraphName(Object graphName) throws IOException {
        boolean isPattern = graphName instanceof Pattern;
        this.outputStream.writeBoolean(isPattern);
        if (isPattern) {
            Pattern pattern = (Pattern)graphName;
            this.outputStream.writeUTF(pattern.pattern());
            this.outputStream.writeInt(pattern.flags());
        } else {
            this.outputStream.writeUTF(graphName.toString());
        }
    }

    private int canonalize(Object object) throws IOException {
        Integer id = this.writtenObjects.get(object);
        if (id != null) {
            return id;
        }
        String toString = object.toString();
        id = this.writtenStrings.get(toString);
        if (id != null) {
            return id;
        }
        id = this.nextInt++;
        this.outputStream.write(2);
        this.outputStream.writeUTF(toString);
        this.writtenObjects.put(object, id);
        this.writtenStrings.put(toString, id);
        return id;
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

