/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class StrlenExecutor
extends StringExecutor {
    private final int KEY_DOES_NOT_EXIST = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the STRELEN command is \"STRLEN key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_STRING, context);
        ByteArrayWrapper valueWrapper = r.get(key);
        if (valueWrapper == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), valueWrapper.toBytes().length));
        }
    }
}

