/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.RegionProvider;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class DecrExecutor
extends StringExecutor {
    private final String ERROR_VALUE_NOT_USABLE = "The value at this key cannot be decremented numerically";
    private final String ERROR_OVERFLOW = "This decrementation cannot be performed due to overflow";
    private final byte[] INIT_VALUE_BYTES = Coder.stringToBytes("-1");
    private final int INIT_VALUE_INT = -1;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Long value;
        List<byte[]> commandElems = command.getProcessedCommand();
        RegionProvider rC = context.getRegionProvider();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = rC.getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the DECR command is \"DECR key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper valueWrapper = r.get(key);
        if (valueWrapper == null) {
            byte[] newValue = this.INIT_VALUE_BYTES;
            r.put(key, new ByteArrayWrapper(newValue));
            rC.metaPut(key, RedisDataType.REDIS_STRING);
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -1));
            return;
        }
        String stringValue = valueWrapper.toString();
        try {
            value = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this key cannot be decremented numerically"));
            return;
        }
        if (value == Long.MIN_VALUE) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This decrementation cannot be performed due to overflow"));
            return;
        }
        Long l = value;
        Long l2 = value = Long.valueOf(value - 1L);
        stringValue = "" + value;
        r.put(key, new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

