/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class DecrByExecutor
extends StringExecutor {
    private final String ERROR_VALUE_NOT_USABLE = "The value at this key cannot be decremented numerically";
    private final String ERROR_DECREMENT_NOT_USABLE = "The decrementation on this key must be numeric";
    private final String ERROR_OVERFLOW = "This decrementation cannot be performed due to overflow";
    private final int DECREMENT_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Long value;
        Long decrement;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the DECRBY command is \"DECRRBY key decrement\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper valueWrapper = r.get(key);
        byte[] decrArray = commandElems.get(2);
        String decrString = Coder.bytesToString(decrArray);
        try {
            decrement = Long.parseLong(decrString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The decrementation on this key must be numeric"));
            return;
        }
        if (valueWrapper == null) {
            String negativeDecrString = decrString.charAt(0) == '-' ? decrString.substring(1) : "-" + decrString;
            r.put(key, new ByteArrayWrapper(Coder.stringToBytes(negativeDecrString)));
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -decrement.longValue()));
            return;
        }
        String stringValue = Coder.bytesToString(valueWrapper.toBytes());
        try {
            value = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this key cannot be decremented numerically"));
            return;
        }
        if (value <= 0L && -decrement.longValue() < Long.MIN_VALUE - value) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This decrementation cannot be performed due to overflow"));
            return;
        }
        value = value - decrement;
        stringValue = "" + value;
        r.put(key, new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

