/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.string;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.string.StringExecutor;
import java.util.List;

public class BitCountExecutor
extends StringExecutor {
    private final String ERROR_NOT_INT = "The indexes provided must be numeric values";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() != 2 && commandElems.size() != 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the BITCOUNT command is \"BITCOUNT key [start end]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper wrapper = r.get(key);
        if (wrapper == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        byte[] value = wrapper.toBytes();
        long startL = 0L;
        long endL = value.length - 1;
        if (commandElems.size() == 4) {
            try {
                startL = Coder.bytesToLong(commandElems.get(2));
                endL = Coder.bytesToLong(commandElems.get(3));
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The indexes provided must be numeric values"));
                return;
            }
        }
        if (startL > Integer.MAX_VALUE || endL > Integer.MAX_VALUE) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided is out of range"));
            return;
        }
        int start = (int)startL;
        int end = (int)endL;
        if (start < 0) {
            start += value.length;
        }
        if (end < 0) {
            end += value.length;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > value.length - 1) {
            end = value.length - 1;
        }
        if (end < start || start >= value.length) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        long setBits = 0L;
        for (int j = start; j <= end; ++j) {
            setBits += (long)Integer.bitCount(0xFF & value[j]);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), setBits));
    }
}

