/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.sortedset;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.DoubleWrapper;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.sortedset.SortedSetExecutor;
import java.util.HashMap;
import java.util.List;

public class ZAddExecutor
extends SortedSetExecutor {
    private final String ERROR_NOT_NUMERICAL = "The inteded score is not a float";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4 || commandElems.size() % 2 == 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZADD command is \"ZADD key score member [score member ...]\", or not every score matches to a member"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        int numberOfAdds = 0;
        if (commandElems.size() > 4) {
            HashMap<ByteArrayWrapper, DoubleWrapper> map = new HashMap<ByteArrayWrapper, DoubleWrapper>();
            for (int i = 2; i < commandElems.size(); ++i) {
                Double score;
                byte[] scoreArray = commandElems.get(i++);
                byte[] memberArray = commandElems.get(i);
                try {
                    score = Coder.bytesToDouble(scoreArray);
                }
                catch (NumberFormatException e) {
                    command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The inteded score is not a float"));
                    return;
                }
                map.put(new ByteArrayWrapper(memberArray), new DoubleWrapper(score));
                ++numberOfAdds;
            }
            Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
            keyRegion.putAll(map);
        } else {
            Double score;
            byte[] scoreArray = commandElems.get(2);
            byte[] memberArray = commandElems.get(3);
            try {
                score = Coder.bytesToDouble(scoreArray);
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The inteded score is not a float"));
                return;
            }
            Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
            DoubleWrapper oldVal = keyRegion.put(new ByteArrayWrapper(memberArray), new DoubleWrapper(score));
            if (oldVal == null) {
                numberOfAdds = 1;
            }
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numberOfAdds));
    }
}

