/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.list;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Extendable;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.list.ListExecutor;
import java.util.List;

public abstract class PushXExecutor
extends ListExecutor
implements Extendable {
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        this.pushElements(key, commandElems, 2, 3, keyRegion, this.pushType(), context);
        int listSize = keyRegion.size() - 2;
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), listSize));
    }

    protected abstract ListExecutor.ListDirection pushType();
}

