/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.list;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Extendable;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.list.ListExecutor;
import com.gemstone.gemfire.internal.redis.executor.list.PushXExecutor;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class PushExecutor
extends PushXExecutor
implements Extendable {
    private final int START_VALUES_INDEX = 2;
    static volatile AtomicInteger puts = new AtomicInteger(0);

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<Integer, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_LIST);
        this.pushElements(key, commandElems, 2, commandElems.size(), keyRegion, this.pushType(), context);
        int listSize = keyRegion.size() - 2;
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), listSize));
    }

    @Override
    protected abstract ListExecutor.ListDirection pushType();
}

