/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.list;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Extendable;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.list.ListExecutor;
import java.util.List;

public abstract class PopExecutor
extends ListExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Integer opp;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null || keyRegion.size() == 2) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        String indexKey = this.popType() == ListExecutor.ListDirection.LEFT ? "head" : "tail";
        String oppositeKey = this.popType() == ListExecutor.ListDirection.RIGHT ? "head" : "tail";
        Integer index = 0;
        int originalIndex = index;
        int incr = this.popType() == ListExecutor.ListDirection.LEFT ? 1 : -1;
        ByteArrayWrapper valueWrapper = null;
        boolean indexChanged = false;
        while (!(index = (Integer)((Object)keyRegion.get(indexKey))).equals(opp = (Integer)((Object)keyRegion.get(oppositeKey))) && !(indexChanged = keyRegion.replace((Integer)((Object)indexKey), (ByteArrayWrapper)((Object)index), (ByteArrayWrapper)((Object)Integer.valueOf(index + incr))))) {
        }
        boolean removed = false;
        int i = 0;
        do {
            if ((valueWrapper = keyRegion.get(index)) != null) {
                removed = keyRegion.remove(index, valueWrapper);
            }
            if (removed) break;
            index = index + incr;
            Integer metaIndex = (Integer)((Object)keyRegion.get(indexKey));
            if (i < 1 && (this.popType() == ListExecutor.ListDirection.LEFT && metaIndex < originalIndex || this.popType() == ListExecutor.ListDirection.RIGHT && metaIndex > originalIndex)) {
                index = metaIndex;
            }
            ++i;
        } while (!removed && keyRegion.size() != 2);
        if (valueWrapper != null) {
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), valueWrapper.toBytes()));
        } else {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
        }
    }

    protected abstract ListExecutor.ListDirection popType();
}

