/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hll;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.hll.CardinalityMergeException;
import com.gemstone.gemfire.internal.hll.HyperLogLogPlus;
import com.gemstone.gemfire.internal.hll.ICardinality;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.hll.HllExecutor;
import java.util.ArrayList;
import java.util.List;

public class PFCountExecutor
extends HllExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PFCOUNT command is \"PFCOUNT key [key ...]\""));
            return;
        }
        Region<ByteArrayWrapper, HyperLogLogPlus> keyRegion = context.getRegionProvider().gethLLRegion();
        ArrayList<HyperLogLogPlus> hlls = new ArrayList<HyperLogLogPlus>();
        for (int i = 1; i < commandElems.size(); ++i) {
            ByteArrayWrapper k = new ByteArrayWrapper(commandElems.get(i));
            this.checkDataType(k, RedisDataType.REDIS_HLL, context);
            HyperLogLogPlus h = keyRegion.get(k);
            if (h == null) continue;
            hlls.add(h);
        }
        if (hlls.isEmpty()) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        HyperLogLogPlus tmp = (HyperLogLogPlus)hlls.remove(0);
        ICardinality[] estimators = hlls.toArray(new HyperLogLogPlus[hlls.size()]);
        try {
            tmp = (HyperLogLogPlus)tmp.merge(estimators);
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
        long cardinality = tmp.cardinality();
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), cardinality));
    }
}

