/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hash;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.AbstractScanExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class HScanExecutor
extends AbstractScanExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        String tmp;
        byte[] bytes;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SSCAN command is \"SSCAN key cursor [MATCH pattern] [COUNT count]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<?, ?> keyRegion = context.getRegionProvider().getRegion(key);
        this.checkDataType(key, RedisDataType.REDIS_HASH, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), new ArrayList()));
            return;
        }
        byte[] cAr = commandElems.get(2);
        String cursorString = Coder.bytesToString(cAr);
        int cursor = 0;
        Pattern matchPattern = null;
        String globMatchPattern = null;
        int count = 10;
        try {
            cursor = Integer.parseInt(cursorString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (cursor < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (commandElems.size() > 4) {
            try {
                bytes = commandElems.get(3);
                tmp = Coder.bytesToString(bytes);
                if (tmp.equalsIgnoreCase("MATCH")) {
                    bytes = commandElems.get(4);
                    globMatchPattern = Coder.bytesToString(bytes);
                } else if (tmp.equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(4);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (commandElems.size() > 6) {
            try {
                bytes = commandElems.get(5);
                tmp = Coder.bytesToString(bytes);
                if (tmp.equalsIgnoreCase("MATCH")) {
                    bytes = commandElems.get(6);
                    globMatchPattern = Coder.bytesToString(bytes);
                } else if (tmp.equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(6);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (count < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
            return;
        }
        try {
            matchPattern = this.convertGlobToRegex(globMatchPattern);
        }
        catch (PatternSyntaxException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Incorrect syntax for given glob regex"));
            return;
        }
        List<Object> returnList = this.getIteration(new HashSet(keyRegion.entrySet()), matchPattern, count, cursor);
        command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), returnList));
    }

    protected List<Object> getIteration(Collection<?> list, Pattern matchPattern, int count, int cursor) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        int size = list.size();
        int beforeCursor = 0;
        int numElements = 0;
        int i = -1;
        for (Map.Entry entry : list) {
            ByteArrayWrapper key = (ByteArrayWrapper)entry.getKey();
            ByteArrayWrapper value = (ByteArrayWrapper)entry.getValue();
            ++i;
            if (beforeCursor < cursor) {
                ++beforeCursor;
                continue;
            }
            if (numElements >= count) break;
            if (matchPattern != null) {
                if (!matchPattern.matcher(key.toString()).matches()) continue;
                returnList.add(key);
                returnList.add(value);
                ++numElements;
                continue;
            }
            returnList.add(key);
            returnList.add(value);
            ++numElements;
        }
        if (i == size - 1) {
            returnList.add(0, String.valueOf(0));
        } else {
            returnList.add(0, String.valueOf(i));
        }
        return returnList;
    }
}

