/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hash;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.hash.HashExecutor;
import java.util.HashMap;
import java.util.List;

public class HMSetExecutor
extends HashExecutor {
    private final String SUCCESS = "OK";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3 || commandElems.size() % 2 == 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HMSET command is \"HMSET key field value [field value ...]\", or not every field is associated with a value"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        HashMap<ByteArrayWrapper, ByteArrayWrapper> map = new HashMap<ByteArrayWrapper, ByteArrayWrapper>();
        for (int i = 2; i < commandElems.size(); i += 2) {
            byte[] fieldArray = commandElems.get(i);
            ByteArrayWrapper field = new ByteArrayWrapper(fieldArray);
            byte[] value = commandElems.get(i + 1);
            map.put(field, new ByteArrayWrapper(value));
        }
        keyRegion.putAll(map);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }
}

