/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor.hash;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.hash.HashExecutor;
import java.util.List;

public class HIncrByFloatExecutor
extends HashExecutor {
    private final String ERROR_FIELD_NOT_USABLE = "The value at this field cannot be incremented numerically because it is not a float";
    private final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be floating point numeric";
    private final int FIELD_INDEX = 2;
    private final int INCREMENT_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Double value;
        Double increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HINCRBYFLOAT command is \"HINCRBYFLOAT key field increment\""));
            return;
        }
        byte[] incrArray = commandElems.get(3);
        try {
            increment = Coder.bytesToDouble(incrArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The increment on this key must be floating point numeric"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        ByteArrayWrapper oldValue = keyRegion.get(field);
        if (oldValue == null) {
            keyRegion.put(field, new ByteArrayWrapper(incrArray));
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), increment));
            return;
        }
        String valueS = oldValue.toString();
        if (valueS.contains(" ")) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this field cannot be incremented numerically because it is not a float"));
            return;
        }
        try {
            value = Coder.stringToDouble(valueS);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this field cannot be incremented numerically because it is not a float"));
            return;
        }
        value = value + increment;
        keyRegion.put(field, new ByteArrayWrapper(Coder.doubleToBytes(value)));
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), value));
    }
}

