/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import java.util.List;

public class TypeExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the TYPE command is \"TYPE key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        RedisDataType type = context.getRegionProvider().getRedisDataType(key);
        if (type == null) {
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), "none"));
        } else {
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), type.toString()));
        }
    }
}

