/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import java.util.List;

public class PersistExecutor
extends AbstractExecutor {
    private final int TIMEOUT_REMOVED = 1;
    private final int KEY_NOT_EXIST_OR_NO_TIMEOUT = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PERSIST command is \"PERSIST key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        boolean canceled = context.getRegionProvider().cancelKeyExpiration(key);
        if (canceled) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

