/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis.executor;

import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.Command;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.Extendable;
import com.gemstone.gemfire.internal.redis.RegionProvider;
import com.gemstone.gemfire.internal.redis.executor.AbstractExecutor;
import java.util.List;

public class ExpireAtExecutor
extends AbstractExecutor
implements Extendable {
    private final String ERROR_TIMESTAMP_NOT_USABLE = "The timestamp specified must be numeric";
    private final int TIMESTAMP_INDEX = 2;
    private final int SET = 1;
    private final int NOT_SET = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long currentTimeMillis;
        long timestamp;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        RegionProvider rC = context.getRegionProvider();
        ByteArrayWrapper wKey = command.getKey();
        byte[] timestampByteArray = commandElems.get(2);
        try {
            timestamp = Coder.bytesToLong(timestampByteArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The timestamp specified must be numeric"));
            return;
        }
        if (!this.timeUnitMillis()) {
            timestamp *= 1000L;
        }
        if (timestamp <= (currentTimeMillis = System.currentTimeMillis())) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        long delayMillis = timestamp - currentTimeMillis;
        boolean expirationSet = false;
        expirationSet = rC.hasExpiration(wKey) ? rC.modifyExpiration(wKey, delayMillis) : rC.setExpiration(wKey, delayMillis);
        if (expirationSet) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }

    protected boolean timeUnitMillis() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the EXPIREAT command is \"EXPIREAT key timestamp\"";
    }
}

