/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.hll.HyperLogLogPlus;
import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.ExecutionHandlerContext;
import com.gemstone.gemfire.internal.redis.RedisDataType;
import com.gemstone.gemfire.internal.redis.RedisDataTypeMismatchException;
import com.gemstone.gemfire.internal.redis.RegionCreationException;
import com.gemstone.gemfire.internal.redis.executor.ExpirationExecutor;
import com.gemstone.gemfire.internal.redis.executor.ListQuery;
import com.gemstone.gemfire.internal.redis.executor.SortedSetQuery;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CreateAlterDestroyRegionCommands;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RegionProvider
implements Closeable {
    private final ConcurrentHashMap<ByteArrayWrapper, Region<?, ?>> regions;
    private final Region<String, RedisDataType> redisMetaRegion;
    private final Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion;
    private final Region<ByteArrayWrapper, HyperLogLogPlus> hLLRegion;
    private final Cache cache;
    private final QueryService queryService;
    private final ConcurrentMap<ByteArrayWrapper, Map<Enum<?>, Query>> preparedQueries = new ConcurrentHashMap();
    private final ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationsMap;
    private final ScheduledExecutorService expirationExecutor;
    private final RegionShortcut defaultRegionType;
    private static final CreateAlterDestroyRegionCommands cliCmds = new CreateAlterDestroyRegionCommands();
    private final ConcurrentHashMap<String, Lock> locks;

    public RegionProvider(Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion, Region<ByteArrayWrapper, HyperLogLogPlus> hLLRegion, Region<String, RedisDataType> redisMetaRegion, ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationsMap, ScheduledExecutorService expirationExecutor, RegionShortcut defaultShortcut) {
        if (stringsRegion == null || hLLRegion == null || redisMetaRegion == null) {
            throw new NullPointerException();
        }
        this.regions = new ConcurrentHashMap();
        this.stringsRegion = stringsRegion;
        this.hLLRegion = hLLRegion;
        this.redisMetaRegion = redisMetaRegion;
        this.cache = GemFireCacheImpl.getInstance();
        this.queryService = this.cache.getQueryService();
        this.expirationsMap = expirationsMap;
        this.expirationExecutor = expirationExecutor;
        this.defaultRegionType = defaultShortcut;
        this.locks = new ConcurrentHashMap();
    }

    public boolean existsKey(ByteArrayWrapper key) {
        return this.redisMetaRegion.containsKey(key.toString());
    }

    public Set<String> metaKeySet() {
        return this.redisMetaRegion.keySet();
    }

    public Set<Map.Entry<String, RedisDataType>> metaEntrySet() {
        return this.redisMetaRegion.entrySet();
    }

    public int getMetaSize() {
        return this.redisMetaRegion.size() - 3;
    }

    private boolean metaRemoveEntry(ByteArrayWrapper key) {
        return this.redisMetaRegion.remove(key.toString()) != null;
    }

    public RedisDataType metaPutIfAbsent(ByteArrayWrapper key, RedisDataType value) {
        return this.redisMetaRegion.putIfAbsent(key.toString(), value);
    }

    public RedisDataType metaPut(ByteArrayWrapper key, RedisDataType value) {
        return this.redisMetaRegion.put(key.toString(), value);
    }

    public RedisDataType metaGet(ByteArrayWrapper key) {
        return this.redisMetaRegion.get(key.toString());
    }

    public Region<?, ?> getRegion(ByteArrayWrapper key) {
        return this.regions.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegionReferenceLocally(ByteArrayWrapper key, RedisDataType type) {
        Lock lock = this.locks.get(key.toString());
        boolean locked = false;
        try {
            locked = lock.tryLock();
            if (locked) {
                this.cancelKeyExpiration(key);
                this.removeRegionState(key, type);
            }
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public boolean removeKey(ByteArrayWrapper key) {
        RedisDataType type = this.getRedisDataType(key);
        return this.removeKey(key, type);
    }

    public boolean removeKey(ByteArrayWrapper key, RedisDataType type) {
        return this.removeKey(key, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(ByteArrayWrapper key, RedisDataType type, boolean cancelExpiration) {
        if (type == null || type == RedisDataType.REDIS_PROTECTED) {
            return false;
        }
        Lock lock = this.locks.get(key.toString());
        try {
            boolean bl;
            block32: {
                block28: {
                    block26: {
                        boolean bl2;
                        block31: {
                            block27: {
                                block24: {
                                    boolean bl3;
                                    block30: {
                                        block25: {
                                            if (lock != null) {
                                                lock.lock();
                                            }
                                            this.metaRemoveEntry(key);
                                            if (type != RedisDataType.REDIS_STRING) break block24;
                                            boolean bl4 = bl3 = this.stringsRegion.remove(key) != null;
                                            if (!cancelExpiration) break block25;
                                            this.cancelKeyExpiration(key);
                                            break block30;
                                        }
                                        this.removeKeyExpiration(key);
                                    }
                                    if (lock != null) {
                                        this.locks.remove(key.toString());
                                    }
                                    return bl3;
                                }
                                if (type != RedisDataType.REDIS_HLL) break block26;
                                boolean bl5 = bl2 = this.hLLRegion.remove(key) != null;
                                if (!cancelExpiration) break block27;
                                this.cancelKeyExpiration(key);
                                break block31;
                            }
                            this.removeKeyExpiration(key);
                        }
                        if (lock != null) {
                            this.locks.remove(key.toString());
                        }
                        return bl2;
                    }
                    try {
                        bl = this.destroyRegion(key, type);
                        if (!cancelExpiration) break block28;
                        this.cancelKeyExpiration(key);
                    }
                    catch (Exception exc) {
                        boolean bl6;
                        block33: {
                            block29: {
                                try {
                                    bl6 = false;
                                    if (!cancelExpiration) break block29;
                                    this.cancelKeyExpiration(key);
                                }
                                catch (Throwable throwable) {
                                    if (cancelExpiration) {
                                        this.cancelKeyExpiration(key);
                                    } else {
                                        this.removeKeyExpiration(key);
                                    }
                                    if (lock != null) {
                                        this.locks.remove(key.toString());
                                    }
                                    throw throwable;
                                }
                                break block33;
                            }
                            this.removeKeyExpiration(key);
                        }
                        if (lock != null) {
                            this.locks.remove(key.toString());
                        }
                        if (lock != null) {
                            lock.unlock();
                        }
                        return bl6;
                    }
                    break block32;
                }
                this.removeKeyExpiration(key);
            }
            if (lock != null) {
                this.locks.remove(key.toString());
            }
            return bl;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public Region<?, ?> getOrCreateRegion(ByteArrayWrapper key, RedisDataType type, ExecutionHandlerContext context) {
        return this.getOrCreateRegion0(key, type, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRemoteRegionReferenceLocally(ByteArrayWrapper key, RedisDataType type) {
        block15: {
            if (type == null || type == RedisDataType.REDIS_STRING || type == RedisDataType.REDIS_HLL) {
                return;
            }
            Region<Object, Object> r = this.regions.get(key);
            if (r != null) {
                return;
            }
            if (!this.regions.contains(key)) {
                String stringKey = key.toString();
                Lock lock = this.locks.get(stringKey);
                if (lock == null) {
                    this.locks.putIfAbsent(stringKey, new ReentrantLock());
                    lock = this.locks.get(stringKey);
                }
                boolean locked = false;
                try {
                    locked = lock.tryLock();
                    if (!locked) break block15;
                    r = this.cache.getRegion(key.toString());
                    if (r == null) {
                        return;
                    }
                    if (type == RedisDataType.REDIS_LIST) {
                        this.doInitializeList(key, r);
                    } else if (type == RedisDataType.REDIS_SORTEDSET) {
                        try {
                            this.doInitializeSortedSet(key, r);
                        }
                        catch (IndexInvalidException | RegionNotFoundException exception) {
                            // empty catch block
                        }
                    }
                    this.regions.put(key, r);
                }
                finally {
                    if (locked) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region<?, ?> getOrCreateRegion0(ByteArrayWrapper key, RedisDataType type, ExecutionHandlerContext context, boolean addToMeta) {
        Region<?, ?> r;
        block18: {
            this.checkDataType(key, type);
            r = this.regions.get(key);
            if (r != null && r.isDestroyed()) {
                this.removeKey(key, type);
                r = null;
            }
            if (r == null) {
                String stringKey = key.toString();
                Lock lock = this.locks.get(stringKey);
                if (lock == null) {
                    this.locks.putIfAbsent(stringKey, new ReentrantLock());
                    lock = this.locks.get(stringKey);
                }
                try {
                    lock.lock();
                    r = this.regions.get(key);
                    if (r != null) break block18;
                    boolean hasTransaction = context != null && context.hasTransaction();
                    CacheTransactionManager txm = null;
                    TransactionId transactionId = null;
                    try {
                        RedisDataType existingType;
                        if (hasTransaction) {
                            txm = this.cache.getCacheTransactionManager();
                            transactionId = txm.suspend();
                        }
                        Exception concurrentCreateDestroyException = null;
                        do {
                            concurrentCreateDestroyException = null;
                            r = this.createRegionGlobally(stringKey);
                            try {
                                if (type == RedisDataType.REDIS_LIST) {
                                    this.doInitializeList(key, r);
                                    continue;
                                }
                                if (type != RedisDataType.REDIS_SORTEDSET) continue;
                                try {
                                    this.doInitializeSortedSet(key, r);
                                }
                                catch (IndexInvalidException | RegionNotFoundException e) {
                                    concurrentCreateDestroyException = e;
                                }
                            }
                            catch (QueryInvalidException e) {
                                if (!(e.getCause() instanceof RegionNotFoundException)) continue;
                                concurrentCreateDestroyException = e;
                            }
                        } while (concurrentCreateDestroyException != null);
                        this.regions.put(key, r);
                        if (addToMeta && (existingType = this.metaPutIfAbsent(key, type)) != null && existingType != type) {
                            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is already used by a " + existingType.toString());
                        }
                        if (hasTransaction) {
                            txm.resume(transactionId);
                        }
                    }
                    catch (Throwable throwable) {
                        if (hasTransaction) {
                            txm.resume(transactionId);
                        }
                        throw throwable;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyRegion(ByteArrayWrapper key, RedisDataType type) {
        Region<?, ?> r = this.regions.get(key);
        if (r != null) {
            try {
                r.destroyRegion();
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.removeRegionState(key, type);
            }
        }
        return true;
    }

    private void removeRegionState(ByteArrayWrapper key, RedisDataType type) {
        this.preparedQueries.remove(key);
        this.regions.remove(key);
    }

    private void doInitializeSortedSet(ByteArrayWrapper key, Region<?, ?> r) throws RegionNotFoundException, IndexInvalidException {
        String fullpath = r.getFullPath();
        try {
            this.queryService.createIndex("scoreIndex", "entry.value.score", r.getFullPath() + ".entrySet entry");
            this.queryService.createIndex("scoreIndex2", "value.score", r.getFullPath() + ".values value");
        }
        catch (IndexExistsException | IndexNameConflictException | UnsupportedOperationException exception) {
            // empty catch block
        }
        HashMap<SortedSetQuery, Query> queryList = new HashMap<SortedSetQuery, Query>();
        for (SortedSetQuery lq : SortedSetQuery.values()) {
            String queryString = lq.getQueryString(fullpath);
            Query query = this.queryService.newQuery(queryString);
            queryList.put(lq, query);
        }
        this.preparedQueries.put(key, queryList);
    }

    private void doInitializeList(ByteArrayWrapper key, Region r) {
        r.put("head", 0);
        r.put("tail", 0);
        String fullpath = r.getFullPath();
        HashMap<ListQuery, Query> queryList = new HashMap<ListQuery, Query>();
        for (ListQuery lq : ListQuery.values()) {
            String queryString = lq.getQueryString(fullpath);
            Query query = this.queryService.newQuery(queryString);
            queryList.put(lq, query);
        }
        this.preparedQueries.put(key, queryList);
    }

    private Region<?, ?> createRegionGlobally(String key) {
        Region r = null;
        r = this.cache.getRegion(key);
        if (r != null) {
            return r;
        }
        do {
            Result result = cliCmds.createRegion(key, this.defaultRegionType, null, null, true, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            r = this.cache.getRegion(key);
            if (result.getStatus() != Result.Status.ERROR || r != null) continue;
            String err = "";
            while (result.hasNextLine()) {
                err = err + result.nextLine();
            }
            throw new RegionCreationException(err);
        } while (r == null);
        return r;
    }

    public Query getQuery(ByteArrayWrapper key, Enum<?> query) {
        return (Query)((Map)this.preparedQueries.get(key)).get(query);
    }

    protected void checkDataType(ByteArrayWrapper key, RedisDataType type) {
        RedisDataType currentType = this.redisMetaRegion.get(key.toString());
        if (currentType == null) {
            return;
        }
        if (currentType == RedisDataType.REDIS_PROTECTED) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is protected");
        }
        if (currentType != type) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is already used by a " + currentType.toString());
        }
    }

    public boolean regionExists(ByteArrayWrapper key) {
        return this.regions.containsKey(key);
    }

    public Region<ByteArrayWrapper, ByteArrayWrapper> getStringsRegion() {
        return this.stringsRegion;
    }

    public Region<ByteArrayWrapper, HyperLogLogPlus> gethLLRegion() {
        return this.hLLRegion;
    }

    private RedisDataType getRedisDataType(String key) {
        return this.redisMetaRegion.get(key);
    }

    public RedisDataType getRedisDataType(ByteArrayWrapper key) {
        return this.getRedisDataType(key.toString());
    }

    public final boolean setExpiration(ByteArrayWrapper key, long delay) {
        RedisDataType type = this.getRedisDataType(key);
        if (type == null) {
            return false;
        }
        ScheduledFuture<?> future = this.expirationExecutor.schedule(new ExpirationExecutor(key, type, this), delay, TimeUnit.MILLISECONDS);
        this.expirationsMap.put(key, future);
        return true;
    }

    public final boolean modifyExpiration(ByteArrayWrapper key, long delay) {
        boolean canceled = this.cancelKeyExpiration(key);
        if (!canceled) {
            return false;
        }
        RedisDataType type = this.getRedisDataType(key);
        if (type == null) {
            return false;
        }
        ScheduledFuture<?> future = this.expirationExecutor.schedule(new ExpirationExecutor(key, type, this), delay, TimeUnit.MILLISECONDS);
        this.expirationsMap.put(key, future);
        return true;
    }

    public final boolean cancelKeyExpiration(ByteArrayWrapper key) {
        ScheduledFuture future = (ScheduledFuture)this.expirationsMap.remove(key);
        if (future == null) {
            return false;
        }
        return future.cancel(false);
    }

    private boolean removeKeyExpiration(ByteArrayWrapper key) {
        return this.expirationsMap.remove(key) != null;
    }

    public boolean hasExpiration(ByteArrayWrapper key) {
        return this.expirationsMap.containsKey(key);
    }

    public final long getExpirationDelayMillis(ByteArrayWrapper key) {
        ScheduledFuture future = (ScheduledFuture)this.expirationsMap.get(key);
        return future != null ? future.getDelay(TimeUnit.MILLISECONDS) : 0L;
    }

    @Override
    public void close() {
        this.preparedQueries.clear();
    }

    public String dumpRegionsCache() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ByteArrayWrapper, Region<?, ?>> e : this.regions.entrySet()) {
            builder.append(e.getKey() + " --> {" + e.getValue() + "}\n");
        }
        return builder.toString();
    }
}

