/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.redis;

import com.gemstone.gemfire.internal.redis.ByteArrayWrapper;
import com.gemstone.gemfire.internal.redis.Coder;
import com.gemstone.gemfire.internal.redis.RedisCommandType;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class Command {
    private final List<byte[]> commandElems;
    private final RedisCommandType commandType;
    private ByteBuf response;
    private String key;
    private ByteArrayWrapper bytes;

    public Command(List<byte[]> commandElems) {
        RedisCommandType type;
        if (commandElems == null || commandElems.isEmpty()) {
            throw new IllegalArgumentException("List of command elements cannot be empty -> List:" + commandElems);
        }
        this.commandElems = commandElems;
        this.response = null;
        try {
            byte[] charCommand = commandElems.get(0);
            String commandName = Coder.bytesToString(charCommand).toUpperCase();
            type = RedisCommandType.valueOf(commandName);
        }
        catch (Exception e) {
            type = RedisCommandType.UNKNOWN;
        }
        this.commandType = type;
    }

    public List<byte[]> getProcessedCommand() {
        return this.commandElems;
    }

    public RedisCommandType getCommandType() {
        return this.commandType;
    }

    public ByteBuf getResponse() {
        return this.response;
    }

    public void setResponse(ByteBuf response) {
        this.response = response;
    }

    public boolean hasError() {
        if (this.response == null) {
            return false;
        }
        return this.response.getByte(0) == 45;
    }

    public String getStringKey() {
        if (this.commandElems.size() > 1) {
            if (this.bytes == null) {
                this.bytes = new ByteArrayWrapper(this.commandElems.get(1));
                this.key = this.bytes.toString();
            } else if (this.key == null) {
                this.key = this.bytes.toString();
            }
            return this.key;
        }
        return null;
    }

    public ByteArrayWrapper getKey() {
        if (this.commandElems.size() > 1) {
            if (this.bytes == null) {
                this.bytes = new ByteArrayWrapper(this.commandElems.get(1));
            }
            return this.bytes;
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (byte[] bs : this.commandElems) {
            b.append(Coder.bytesToString(bs));
            b.append(' ');
        }
        return b.toString();
    }
}

