/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process.signal;

import com.gemstone.gemfire.internal.process.signal.Signal;
import com.gemstone.gemfire.internal.process.signal.SignalEvent;
import com.gemstone.gemfire.internal.process.signal.SignalListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSignalNotificationHandler {
    @Deprecated
    protected static final List<String> SIGNAL_NAMES;
    protected static final SignalListener LOGGING_SIGNAL_LISTENER;
    protected static final SignalListener NO_OP_SIGNAL_LISTENER;
    private final Map<Signal, Set<SignalListener>> signalListeners = Collections.synchronizedMap(new HashMap(Signal.values().length));

    protected static void assertNotNull(Object obj, String message, Object ... arguments) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, arguments));
        }
    }

    protected static void assertState(boolean state, String message, Object ... arguments) {
        if (!state) {
            throw new IllegalStateException(String.format(message, arguments));
        }
    }

    protected static void assertValidArgument(boolean valid, String message, Object ... arguments) {
        if (!valid) {
            throw new IllegalArgumentException(String.format(message, arguments));
        }
    }

    public AbstractSignalNotificationHandler() {
        for (Signal signal : Signal.values()) {
            this.signalListeners.put(signal, Collections.synchronizedSet(new HashSet()));
        }
    }

    public boolean hasListeners(Signal signal) {
        return !this.signalListeners.get((Object)signal).isEmpty();
    }

    public boolean isListening(SignalListener listener) {
        boolean registered = false;
        for (Signal signal : Signal.values()) {
            registered |= this.isListening(listener, signal);
        }
        return registered;
    }

    public boolean isListening(SignalListener listener, Signal signal) {
        AbstractSignalNotificationHandler.assertNotNull((Object)signal, "The signal to determine whether the listener is registered listening for cannot be null!", new Object[0]);
        return this.signalListeners.get((Object)signal).contains(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(SignalEvent event) {
        Set<SignalListener> listeners = this.signalListeners.get((Object)event.getSignal());
        Set<SignalListener> localListeners = Collections.emptySet();
        if (listeners != null) {
            Set<SignalListener> set = listeners;
            synchronized (set) {
                localListeners = new HashSet<SignalListener>(listeners);
            }
        }
        for (SignalListener listener : localListeners) {
            listener.handle(event);
        }
    }

    public boolean registerListener(SignalListener listener) {
        AbstractSignalNotificationHandler.assertNotNull(listener, "The SignalListener to register, listening for all signals cannot be null!", new Object[0]);
        boolean registered = false;
        for (Signal signal : Signal.values()) {
            registered |= this.registerListener(listener, signal);
        }
        return registered;
    }

    public boolean registerListener(SignalListener listener, Signal signal) {
        AbstractSignalNotificationHandler.assertNotNull((Object)signal, "The signal to register the listener for cannot be null!", new Object[0]);
        AbstractSignalNotificationHandler.assertNotNull(listener, "The SignalListener being registered to listen for '%1$s' signals cannot be null!", signal.getName());
        return this.signalListeners.get((Object)signal).add(listener);
    }

    public boolean unregisterListener(SignalListener listener) {
        boolean unregistered = false;
        for (Signal signal : Signal.values()) {
            unregistered |= this.unregisterListener(listener, signal);
        }
        return unregistered;
    }

    public boolean unregisterListener(SignalListener listener, Signal signal) {
        AbstractSignalNotificationHandler.assertNotNull((Object)signal, "The signal from which to unregister the listener cannot be null!", new Object[0]);
        return this.signalListeners.get((Object)signal).remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListeners(Signal signal) {
        Set<SignalListener> listeners;
        AbstractSignalNotificationHandler.assertNotNull((Object)signal, "The signal from which to unregister all listeners cannot be null!", new Object[0]);
        Set<SignalListener> set = listeners = this.signalListeners.get((Object)signal);
        synchronized (set) {
            listeners.clear();
            return listeners.isEmpty();
        }
    }

    static {
        String[] SIGNAL_NAMES_ARRAY = new String[]{"", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};
        SIGNAL_NAMES = Collections.unmodifiableList(Arrays.asList(SIGNAL_NAMES_ARRAY));
        LOGGING_SIGNAL_LISTENER = new SignalListener(){

            @Override
            public void handle(SignalEvent event) {
                System.out.printf("Logging SignalListener Received Signal '%1$s' (%2$d)%n", event.getSignal().getName(), event.getSignal().getNumber());
            }
        };
        NO_OP_SIGNAL_LISTENER = new SignalListener(){

            @Override
            public void handle(SignalEvent event) {
            }
        };
    }
}

