/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.internal.util.StopWatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PidFile {
    private static final long SLEEP_INTERVAL_MILLIS = 10L;
    private final File pidFile;

    public PidFile(File file) throws FileNotFoundException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("Unable to find PID file '" + file + "'");
        }
        this.pidFile = file;
    }

    File getFile() {
        return this.pidFile;
    }

    public PidFile(File directory, String filename) throws FileNotFoundException {
        if (!directory.isDirectory() && directory.exists()) {
            throw new IllegalArgumentException("Argument '" + directory + "' must be an existing directory!");
        }
        File file = new File(directory, filename);
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException("Unable to find PID file '" + filename + "' in directory " + directory);
        }
        this.pidFile = file;
    }

    public int readPid() throws IOException {
        int n;
        BufferedReader fileReader = null;
        String pidValue = null;
        try {
            fileReader = new BufferedReader(new FileReader(this.pidFile));
            pidValue = fileReader.readLine();
            int pid = Integer.parseInt(pidValue);
            if (pid < 1) {
                throw new IllegalArgumentException("Invalid pid '" + pid + "' found in " + this.pidFile.getCanonicalPath());
            }
            n = pid;
        }
        catch (NumberFormatException e) {
            try {
                throw new IllegalArgumentException("Invalid pid '" + pidValue + "' found in " + this.pidFile.getCanonicalPath());
            }
            catch (Throwable throwable) {
                IOUtils.close(fileReader);
                throw throwable;
            }
        }
        IOUtils.close(fileReader);
        return n;
    }

    public int readPid(long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        IllegalArgumentException iae = null;
        IOException ioe = null;
        int pid = 0;
        long timeoutMillis = unit.toMillis(timeout);
        StopWatch stopWatch = new StopWatch(true);
        while (pid <= 0) {
            try {
                pid = this.readPid();
            }
            catch (IllegalArgumentException e) {
                iae = e;
            }
            catch (IOException e) {
                ioe = e;
            }
            if (stopWatch.elapsedTimeMillis() > timeoutMillis) {
                if (iae != null) {
                    throw new TimeoutException(iae.getMessage());
                }
                if (ioe == null) continue;
                throw new TimeoutException(ioe.getMessage());
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (iae != null) {
                    throw new InterruptedException(iae.getMessage());
                }
                if (ioe != null) {
                    throw new InterruptedException(ioe.getMessage());
                }
                throw e;
            }
        }
        return pid;
    }
}

