/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import com.gemstone.gemfire.internal.offheap.AddressableMemoryManager;
import com.gemstone.gemfire.internal.offheap.Slab;

public class SlabImpl
implements Slab {
    private final long address;
    private final int size;

    public SlabImpl(int size) {
        this(AddressableMemoryManager.allocate(size), size);
    }

    public SlabImpl(long addr, int size) {
        this.address = addr;
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getMemoryAddress() {
        return this.address;
    }

    @Override
    public void free() {
        AddressableMemoryManager.free(this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("MemoryAddress=").append(this.getMemoryAddress());
        sb.append(", Size=").append(this.getSize());
        sb.append("}");
        return sb.toString();
    }
}

