/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.offheap.MemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.RefCountChangeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ReferenceCountHelper {
    private static final boolean trackRefCounts = Boolean.getBoolean("gemfire.trackOffHeapRefCounts");
    private static final boolean trackFreedRefCounts = Boolean.getBoolean("gemfire.trackOffHeapFreedRefCounts");
    private static final ConcurrentMap<Long, List<RefCountChangeInfo>> stacktraces;
    private static final ConcurrentMap<Long, List<RefCountChangeInfo>> freedStacktraces;
    private static final ThreadLocal<Object> refCountOwner;
    private static final ThreadLocal<AtomicInteger> refCountReenterCount;
    private static final Object SKIP_REF_COUNT_TRACKING;
    private static final List<RefCountChangeInfo> LOCKED;

    private ReferenceCountHelper() {
    }

    public static boolean trackReferenceCounts() {
        return trackRefCounts;
    }

    public static boolean trackFreedReferenceCounts() {
        return trackFreedRefCounts;
    }

    public static void setReferenceCountOwner(Object owner) {
        if (ReferenceCountHelper.trackReferenceCounts()) {
            if (refCountOwner.get() != null) {
                AtomicInteger ai = refCountReenterCount.get();
                if (owner != null) {
                    ai.incrementAndGet();
                } else if (ai.decrementAndGet() <= 0) {
                    refCountOwner.set(null);
                    ai.set(0);
                }
            } else {
                AtomicInteger ai = refCountReenterCount.get();
                if (ai == null) {
                    ai = new AtomicInteger(0);
                    refCountReenterCount.set(ai);
                }
                if (owner != null) {
                    ai.set(1);
                } else {
                    ai.set(0);
                }
                refCountOwner.set(owner);
            }
        }
    }

    public static Object createReferenceCountOwner() {
        Object result = null;
        if (ReferenceCountHelper.trackReferenceCounts()) {
            result = new Object();
            ReferenceCountHelper.setReferenceCountOwner(result);
        }
        return result;
    }

    public static void skipRefCountTracking() {
        ReferenceCountHelper.setReferenceCountOwner(SKIP_REF_COUNT_TRACKING);
    }

    public static void unskipRefCountTracking() {
        ReferenceCountHelper.setReferenceCountOwner(null);
    }

    public static List<RefCountChangeInfo> getRefCountInfo(long address) {
        if (!ReferenceCountHelper.trackReferenceCounts()) {
            return null;
        }
        List result = (List)stacktraces.get(address);
        while (result != null && !stacktraces.replace(address, result, LOCKED)) {
            result = (List)stacktraces.get(address);
        }
        return result;
    }

    public static List<RefCountChangeInfo> getFreeRefCountInfo(long address) {
        if (!ReferenceCountHelper.trackReferenceCounts() || !ReferenceCountHelper.trackFreedReferenceCounts()) {
            return null;
        }
        return (List)freedStacktraces.get(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refCountChanged(Long address, boolean decRefCount, int rc) {
        List newList;
        Object owner = refCountOwner.get();
        if (owner == SKIP_REF_COUNT_TRACKING) {
            return;
        }
        List list = (List)stacktraces.get(address);
        if (list == null) {
            newList = new ArrayList();
            List old = stacktraces.putIfAbsent(address, newList);
            list = old == null ? newList : old;
        }
        if (decRefCount && owner != null) {
            newList = list;
            synchronized (newList) {
                for (int i = 0; i < list.size(); ++i) {
                    RefCountChangeInfo info = (RefCountChangeInfo)list.get(i);
                    if (owner instanceof RegionEntry) {
                        if (owner != info.getOwner()) continue;
                        if (info.getUseCount() > 0) {
                            info.decUseCount();
                        } else {
                            list.remove(i);
                        }
                        return;
                    }
                    if (!owner.equals(info.getOwner())) continue;
                    if (info.getUseCount() > 0) {
                        info.decUseCount();
                    } else {
                        list.remove(i);
                    }
                    return;
                }
            }
        }
        if (list == LOCKED) {
            MemoryAllocatorImpl.debugLog("refCount " + (decRefCount ? "deced" : "inced") + " after orphan detected for @" + Long.toHexString(address), true);
            return;
        }
        RefCountChangeInfo info = new RefCountChangeInfo(decRefCount, rc, owner);
        List list2 = list;
        synchronized (list2) {
            for (RefCountChangeInfo e : list) {
                if (!e.isSameCaller(info)) continue;
                e.incUseCount();
                return;
            }
            list.add(info);
        }
    }

    static void freeRefCountInfo(Long address) {
        if (!ReferenceCountHelper.trackReferenceCounts()) {
            return;
        }
        List freedInfo = (List)stacktraces.remove(address);
        if (freedInfo == LOCKED) {
            MemoryAllocatorImpl.debugLog("freed after orphan detected for @" + Long.toHexString(address), true);
        } else if (ReferenceCountHelper.trackFreedReferenceCounts()) {
            if (freedInfo != null) {
                freedStacktraces.put(address, freedInfo);
            } else {
                freedStacktraces.remove(address);
            }
        }
    }

    static {
        SKIP_REF_COUNT_TRACKING = new Object();
        LOCKED = Collections.emptyList();
        if (trackRefCounts) {
            stacktraces = new ConcurrentHashMap<Long, List<RefCountChangeInfo>>();
            freedStacktraces = trackFreedRefCounts ? new ConcurrentHashMap<Long, List<RefCountChangeInfo>>() : null;
            refCountOwner = new ThreadLocal();
            refCountReenterCount = new ThreadLocal();
        } else {
            stacktraces = null;
            freedStacktraces = null;
            refCountOwner = null;
            refCountReenterCount = null;
        }
    }
}

