/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.offheap;

import com.gemstone.gemfire.internal.offheap.MemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.OffHeapStoredObject;
import org.apache.logging.log4j.Logger;

public class OffHeapStoredObjectAddressStack {
    private volatile long topAddr;

    public OffHeapStoredObjectAddressStack(long addr) {
        if (addr != 0L) {
            MemoryAllocatorImpl.validateAddress(addr);
        }
        this.topAddr = addr;
    }

    public OffHeapStoredObjectAddressStack() {
        this.topAddr = 0L;
    }

    public boolean isEmpty() {
        return this.topAddr == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(long e) {
        assert (e != 0L);
        MemoryAllocatorImpl.validateAddress(e);
        OffHeapStoredObjectAddressStack offHeapStoredObjectAddressStack = this;
        synchronized (offHeapStoredObjectAddressStack) {
            OffHeapStoredObject.setNext(e, this.topAddr);
            this.topAddr = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long poll() {
        long result;
        OffHeapStoredObjectAddressStack offHeapStoredObjectAddressStack = this;
        synchronized (offHeapStoredObjectAddressStack) {
            result = this.topAddr;
            if (result != 0L) {
                this.topAddr = OffHeapStoredObject.getNext(result);
            }
        }
        return result;
    }

    public long getTopAddress() {
        return this.topAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clear() {
        long result;
        OffHeapStoredObjectAddressStack offHeapStoredObjectAddressStack = this;
        synchronized (offHeapStoredObjectAddressStack) {
            result = this.topAddr;
            if (result != 0L) {
                this.topAddr = 0L;
            }
        }
        return result;
    }

    public void logSizes(Logger logger, String msg) {
        boolean concurrentModDetected;
        long headAddr = this.topAddr;
        block0: do {
            concurrentModDetected = false;
            long addr = headAddr;
            while (addr != 0L) {
                int curSize = OffHeapStoredObject.getSize(addr);
                addr = OffHeapStoredObject.getNext(addr);
                this.testHookDoConcurrentModification();
                long curHead = this.topAddr;
                if (curHead != headAddr) {
                    headAddr = curHead;
                    concurrentModDetected = true;
                    continue block0;
                }
                logger.info(msg + curSize);
            }
        } while (concurrentModDetected);
    }

    public long computeTotalSize() {
        long result;
        boolean concurrentModDetected;
        long headAddr = this.topAddr;
        block0: do {
            concurrentModDetected = false;
            result = 0L;
            long addr = headAddr;
            while (addr != 0L) {
                result += (long)OffHeapStoredObject.getSize(addr);
                addr = OffHeapStoredObject.getNext(addr);
                this.testHookDoConcurrentModification();
                long curHead = this.topAddr;
                if (curHead == headAddr) continue;
                headAddr = curHead;
                concurrentModDetected = true;
                continue block0;
            }
        } while (concurrentModDetected);
        return result;
    }

    protected void testHookDoConcurrentModification() {
    }
}

