/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import java.nio.ByteBuffer;

public class SetCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key, byte[] value, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = SetCommand.getMemcachedRegion(cache);
        r.put(key, ValueWrapper.getWrappedValue(value, flags));
        return asciiCharset.encode(Reply.STORED.toString());
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key, byte[] value, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = SetCommand.getMemcachedRegion(cache);
        ValueWrapper val = ValueWrapper.getWrappedValue(value, flags);
        boolean success = true;
        try {
            if (cas != 0L) {
                ValueWrapper expected = ValueWrapper.getDummyValue(cas);
                success = r.replace(key, expected, val);
            } else {
                r.put(key, val);
            }
            if (this.getLogger().fineEnabled()) {
                this.getLogger().fine("set key:" + key + " succedded:" + success);
            }
            if (success) {
                if (this.isQuiet()) {
                    return null;
                }
                response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                response.putLong(16, val.getVersion());
            } else {
                response.putShort(6, ResponseStatus.KEY_EXISTS.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key, request, response, "set", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

