/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging.log4j;

import com.gemstone.gemfire.internal.logging.LogService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilterable;

public class Configurator {
    public static void shutdown() {
        LoggerContext context = ((Logger)LogManager.getRootLogger()).getContext();
        context.stop();
        org.apache.logging.log4j.core.config.Configurator.shutdown((LoggerContext)context);
    }

    public static void setLevel(String name, Level level) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig logConfig = Configurator.getLoggerConfig(name);
        logConfig.setLevel(level);
        context.updateLoggers();
        if (level.isLessSpecificThan(Level.DEBUG)) {
            LogService.configureFastLoggerDelegating();
        }
    }

    public static Level getLevel(String name) {
        LoggerConfig logConfig = Configurator.getOrCreateLoggerConfig(name);
        return logConfig.getLevel();
    }

    public static LoggerConfig getOrCreateLoggerConfig(String name) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig logConfig = config.getLoggerConfig(name);
        boolean update = false;
        if (!logConfig.getName().equals(name)) {
            List appenderRefs = logConfig.getAppenderRefs();
            Map properties = logConfig.getProperties();
            Set props = properties == null ? null : properties.keySet();
            logConfig = LoggerConfig.createLogger((String)String.valueOf(logConfig.isAdditive()), (Level)logConfig.getLevel(), (String)name, (String)String.valueOf(logConfig.isIncludeLocation()), (AppenderRef[])(appenderRefs == null ? null : appenderRefs.toArray(new AppenderRef[appenderRefs.size()])), props == null ? null : props.toArray(new Property[props.size()]), (Configuration)config, null);
            config.addLogger(name, logConfig);
            update = true;
        }
        if (update) {
            context.updateLoggers();
        }
        return logConfig;
    }

    public static LoggerConfig getOrCreateLoggerConfig(String name, boolean additive, boolean forceAdditivity) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig logConfig = config.getLoggerConfig(name);
        boolean update = false;
        if (!logConfig.getName().equals(name)) {
            List appenderRefs = logConfig.getAppenderRefs();
            Map properties = logConfig.getProperties();
            Set props = properties == null ? null : properties.keySet();
            logConfig = LoggerConfig.createLogger((String)String.valueOf(additive), (Level)logConfig.getLevel(), (String)name, (String)String.valueOf(logConfig.isIncludeLocation()), (AppenderRef[])(appenderRefs == null ? null : appenderRefs.toArray(new AppenderRef[appenderRefs.size()])), props == null ? null : props.toArray(new Property[props.size()]), (Configuration)config, null);
            config.addLogger(name, logConfig);
            update = true;
        }
        if (forceAdditivity && logConfig.isAdditive() != additive) {
            logConfig.setAdditive(additive);
            update = true;
        }
        if (update) {
            context.updateLoggers();
        }
        return logConfig;
    }

    public static LoggerConfig getLoggerConfig(String name) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig logConfig = config.getLoggerConfig(name);
        if (!logConfig.getName().equals(name)) {
            throw new IllegalStateException("LoggerConfig does not exist for " + name);
        }
        return logConfig;
    }

    public static boolean hasContextWideFilter(Configuration config) {
        return config.hasFilter();
    }

    public static String getConfigurationSourceLocation(Configuration config) {
        return config.getConfigurationSource().getLocation();
    }

    public static boolean hasAppenderFilter(Configuration config) {
        for (Appender appender : config.getAppenders().values()) {
            if (!(appender instanceof AbstractFilterable) || !((AbstractFilterable)appender).hasFilter()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDebugOrLower(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isDebugOrLower = loggerConfig.getLevel().isLessSpecificThan(Level.DEBUG);
            if (!isDebugOrLower) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLoggerFilter(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isGemFireVerboseFilter;
            boolean isRoot = loggerConfig.getName().equals("");
            boolean isGemFire = loggerConfig.getName().startsWith("com.gemstone");
            boolean hasFilter = loggerConfig.hasFilter();
            boolean bl = isGemFireVerboseFilter = hasFilter && "{GEMFIRE_VERBOSE}".equals(loggerConfig.getFilter().toString());
            if (!isRoot && !isGemFire || !hasFilter || isGemFireVerboseFilter) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAppenderRefFilter(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isGemFireVerboseFilter;
            boolean isRoot = loggerConfig.getName().equals("");
            boolean isGemFire = loggerConfig.getName().startsWith("com.gemstone");
            boolean hasFilter = loggerConfig.hasFilter();
            boolean bl = isGemFireVerboseFilter = hasFilter && "{GEMFIRE_VERBOSE}".equals(loggerConfig.getFilter().toString());
            if (!isRoot && !isGemFire) continue;
            for (AppenderRef appenderRef : loggerConfig.getAppenderRefs()) {
                if (appenderRef.getFilter() == null) continue;
                return true;
            }
        }
        return false;
    }
}

