/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging.log4j;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.admin.remote.AlertListenerMessage;
import com.gemstone.gemfire.internal.lang.ThreadUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.AppenderContext;
import com.gemstone.gemfire.internal.tcp.ReenteredConnectException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class AlertAppender
extends AbstractAppender
implements PropertyChangeListener {
    private static final String APPENDER_NAME = AlertAppender.class.getName();
    private static final Logger logger = LogService.getLogger();
    private static final AlertAppender instance = new AlertAppender();
    private static final ThreadLocal<Boolean> alerting = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private final AppenderContext appenderContext = LogService.getAppenderContext();
    private volatile boolean alertingDisabled = false;

    private AlertAppender() {
        super(APPENDER_NAME, null, (Layout)PatternLayout.createDefaultLayout());
        this.start();
    }

    public static AlertAppender getInstance() {
        return instance;
    }

    public static boolean isThreadAlerting() {
        return alerting.get();
    }

    public boolean isAlertingDisabled() {
        return this.alertingDisabled;
    }

    public void setAlertingDisabled(boolean alertingDisabled) {
        this.alertingDisabled = alertingDisabled;
    }

    public static void setIsAlerting(boolean isAlerting) {
        alerting.set(isAlerting ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        if (this.alertingDisabled) {
            return;
        }
        if (alerting.get().booleanValue()) {
            return;
        }
        AlertAppender.setIsAlerting(true);
        try {
            InternalDistributedSystem ds;
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("Delivering an alert event: {}", new Object[]{event});
            }
            if ((ds = InternalDistributedSystem.getConnectedInstance()) == null) {
                logger.info("Did not append alert event because the distributed system is set to null.");
                return;
            }
            DistributionManager distMgr = (DistributionManager)ds.getDistributionManager();
            int intLevel = AlertAppender.logLevelToAlertLevel(event.getLevel().intLevel());
            Date date = new Date(event.getTimeMillis());
            String threadName = event.getThreadName();
            String logMessage = event.getMessage().getFormattedMessage();
            String stackTrace = ThreadUtils.stackTraceToString(event.getThrown(), true);
            String connectionName = ds.getConfig().getName();
            for (Listener listener : this.listeners) {
                if (event.getLevel().intLevel() > listener.getLevel().intLevel()) {
                    break;
                }
                try {
                    AlertListenerMessage alertMessage = AlertListenerMessage.create(listener.getMember(), intLevel, date, connectionName, threadName, Thread.currentThread().getId(), logMessage, stackTrace);
                    if (listener.getMember().equals(distMgr.getDistributionManagerId())) {
                        if (isDebugEnabled) {
                            logger.debug("Delivering local alert message: {}, {}, {}, {}, {}, [{}], [{}].", new Object[]{listener.getMember(), intLevel, date, connectionName, threadName, logMessage, stackTrace});
                        }
                        alertMessage.process(distMgr);
                        continue;
                    }
                    if (isDebugEnabled) {
                        logger.debug("Delivering remote alert message: {}, {}, {}, {}, {}, [{}], [{}].", new Object[]{listener.getMember(), intLevel, date, connectionName, threadName, logMessage, stackTrace});
                    }
                    distMgr.putOutgoing(alertMessage);
                }
                catch (ReenteredConnectException reenteredConnectException) {}
            }
        }
        finally {
            AlertAppender.setIsAlerting(false);
        }
    }

    public synchronized void addAlertListener(DistributedMember member, int alertLevel) {
        Level level = LogService.toLevel(AlertAppender.alertLevelToLogLevel(alertLevel));
        if (this.listeners.size() == 0) {
            this.appenderContext.getLoggerContext().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.addListenerToSortedList(new Listener(level, member));
        LoggerConfig loggerConfig = this.appenderContext.getLoggerConfig();
        loggerConfig.addAppender((Appender)this, this.listeners.get(0).getLevel(), null);
        if (logger.isDebugEnabled()) {
            logger.debug("Added/Replaced alert listener for member {} at level {}", new Object[]{member, level});
        }
    }

    public synchronized boolean removeAlertListener(DistributedMember member) {
        boolean memberWasFound = this.listeners.remove(new Listener(null, member));
        if (memberWasFound) {
            if (this.listeners.size() == 0) {
                this.appenderContext.getLoggerContext().removePropertyChangeListener((PropertyChangeListener)this);
                this.appenderContext.getLoggerConfig().removeAppender(APPENDER_NAME);
            } else {
                LoggerConfig loggerConfig = this.appenderContext.getLoggerConfig();
                loggerConfig.addAppender((Appender)this, this.listeners.get(0).getLevel(), null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Removed alert listener for member {}", new Object[]{member});
            }
        }
        return memberWasFound;
    }

    public synchronized boolean hasAlertListener(DistributedMember member, int alertLevel) {
        Level level = LogService.toLevel(AlertAppender.alertLevelToLogLevel(alertLevel));
        for (Listener listener : this.listeners) {
            if (!listener.getMember().equals(member) || !listener.getLevel().equals((Object)level)) continue;
            return true;
        }
        if (alertLevel == Integer.MAX_VALUE) {
            for (Listener listener : this.listeners) {
                if (!listener.getMember().equals(member)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        LoggerConfig loggerConfig;
        if (logger.isDebugEnabled()) {
            logger.debug("Responding to a property change event. Property name is {}.", new Object[]{evt.getPropertyName()});
        }
        if (evt.getPropertyName().equals("config") && !(loggerConfig = this.appenderContext.getLoggerConfig()).getAppenders().containsKey(APPENDER_NAME)) {
            loggerConfig.addAppender((Appender)this, this.listeners.get(0).getLevel(), null);
        }
    }

    private void addListenerToSortedList(Listener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (listener.getLevel().compareTo(this.listeners.get(i).getLevel()) < 0) continue;
            this.listeners.add(i, listener);
            return;
        }
        this.listeners.add(listener);
    }

    public static int alertLevelToLogLevel(int alertLevel) {
        switch (alertLevel) {
            case 1000: {
                return Level.FATAL.intLevel();
            }
            case 950: {
                return Level.ERROR.intLevel();
            }
            case 900: {
                return Level.WARN.intLevel();
            }
            case 0x7FFFFFFF: {
                return Level.OFF.intLevel();
            }
        }
        throw new IllegalArgumentException("Unknown Alert level [" + alertLevel + "].");
    }

    public static int logLevelToAlertLevel(int logLevel) {
        if (logLevel == Level.FATAL.intLevel()) {
            return 1000;
        }
        if (logLevel == Level.ERROR.intLevel()) {
            return 950;
        }
        if (logLevel == Level.WARN.intLevel()) {
            return 900;
        }
        if (logLevel == Level.OFF.intLevel()) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unknown Log level [" + logLevel + "].");
    }

    public synchronized void shuttingDown() {
        this.listeners.clear();
        this.appenderContext.getLoggerContext().removePropertyChangeListener((PropertyChangeListener)this);
        this.appenderContext.getLoggerConfig().removeAppender(APPENDER_NAME);
    }

    static class Listener {
        private Level level;
        private DistributedMember member;

        public Level getLevel() {
            return this.level;
        }

        public DistributedMember getMember() {
            return this.member;
        }

        Listener(Level level, DistributedMember member) {
            this.level = level;
            this.member = member;
        }

        public int hashCode() {
            return 31 + (this.member == null ? 0 : this.member.hashCode());
        }

        public boolean equals(Object other) {
            return this.member.equals(((Listener)other).member);
        }

        public String toString() {
            return "Listener [level=" + this.level + ", member=" + this.member + "]";
        }
    }
}

