/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Banner;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogConfig;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.SecurityLogWriter;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;

public class LogWriterFactory {
    public static InternalLogWriter toSecurityLogWriter(InternalLogWriter logWriter) {
        return new SecurityLogWriter(logWriter.getLogWriterLevel(), logWriter);
    }

    public static InternalLogWriter createLogWriterLogger(boolean isLoner, boolean isSecure, LogConfig config, boolean logConfig) {
        String name = null;
        name = isSecure ? "com.gemstone.gemfire.security" : "com.gemstone.gemfire";
        LogWriterLogger logger = LogService.createLogWriterLogger(name, config.getName(), isSecure);
        if (isSecure) {
            logger.setLogWriterLevel(((DistributionConfig)config).getSecurityLogLevel());
        } else {
            ConfigSource source;
            boolean defaultSource = false;
            if (config instanceof DistributionConfig && (source = ((DistributionConfig)config).getConfigSource("log-level")) == null) {
                defaultSource = true;
            }
            if (!defaultSource) {
                logger.setLogWriterLevel(config.getLogLevel());
            }
        }
        if (!(InternalDistributedSystem.getReconnectAttemptCounter() != 0 || isSecure || isLoner && Boolean.getBoolean("Locator.inhibitDMBanner"))) {
            logger.info(LogMarker.CONFIG, Banner.getString(null));
        }
        if (logConfig && !isLoner) {
            logger.info(LogMarker.CONFIG, LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_STARTUP_CONFIGURATIONN_0, config.toLoggerString()));
        }
        return logger;
    }
}

