/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.lang;

import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.lang.ObjectUtils;

public abstract class StringUtils {
    public static final String COMMA_DELIMITER = ",";
    public static final String EMPTY_STRING = "";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SPACE = " ";
    public static final String UTF_8 = "UTF-8";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};
    private static final int MAX_ARRAY_ELEMENTS_TO_CONVERT = Integer.getInteger("StringUtils.MAX_ARRAY_ELEMENTS_TO_CONVERT", 16);

    public static String concat(Object ... values) {
        return StringUtils.concat(values, EMPTY_STRING);
    }

    public static String concat(Object[] values, String delimiter) {
        delimiter = ObjectUtils.defaultIfNull(delimiter, EMPTY_STRING);
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        if (values != null) {
            for (Object value : values) {
                buffer.append(count++ > 0 ? delimiter : EMPTY_STRING);
                buffer.append(value);
            }
        }
        return buffer.toString();
    }

    public static String defaultIfBlank(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (StringUtils.isBlank(value)) continue;
                return value;
            }
        }
        return null;
    }

    public static String getDigitsOnly(String value) {
        StringBuilder buffer = new StringBuilder();
        if (value != null) {
            for (char chr : value.toCharArray()) {
                if (!Character.isDigit(chr)) continue;
                buffer.append(chr);
            }
        }
        return buffer.toString();
    }

    public static String getLettersOnly(String value) {
        StringBuilder buffer = new StringBuilder();
        if (value != null) {
            for (char chr : value.toCharArray()) {
                if (!Character.isLetter(chr)) continue;
                buffer.append(chr);
            }
        }
        return buffer.toString();
    }

    public static String getSpaces(int number) {
        StringBuilder spaces = new StringBuilder(SPACES[Math.min(number, SPACES.length - 1)]);
        do {
            number -= SPACES.length - 1;
            number = Math.max(number, 0);
            spaces.append(SPACES[Math.min(number, SPACES.length - 1)]);
        } while (number > 0);
        return spaces.toString();
    }

    public static boolean isBlank(String value) {
        return value == null || EMPTY_STRING.equals(value.trim());
    }

    public static boolean isEmpty(String value) {
        return EMPTY_STRING.equals(value);
    }

    public static String padEnding(String value, char paddingCharacter, int length) {
        if (value == null) {
            throw new NullPointerException("The String value to pad cannot be null!");
        }
        StringBuilder buffer = new StringBuilder(value);
        for (int valueLength = value.length(); valueLength < length; ++valueLength) {
            buffer.append(paddingCharacter);
        }
        return buffer.toString();
    }

    public static String toLowerCase(String value) {
        return value == null ? null : value.toLowerCase();
    }

    public static String toUpperCase(String value) {
        return value == null ? null : value.toUpperCase();
    }

    public static String trim(String value) {
        return value == null ? null : value.trim();
    }

    public static String truncate(String value, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be greater than equal to 0!");
        }
        return value == null ? null : value.substring(0, Math.min(value.length(), length));
    }

    public static String valueOf(Object value, String ... defaultValues) {
        if (value != null) {
            return value.toString();
        }
        if (defaultValues != null) {
            for (String defaultValue : defaultValues) {
                if (defaultValue == null) continue;
                return defaultValue;
            }
        }
        return String.valueOf(value);
    }

    public static String wrap(String line, int widthInCharacters, String indent) {
        StringBuilder buffer = new StringBuilder();
        int lineCount = 1;
        int spaceIndex = -1;
        indent = StringUtils.valueOf(indent, EMPTY_STRING);
        while (line.length() > widthInCharacters) {
            spaceIndex = line.substring(0, widthInCharacters).lastIndexOf(SPACE);
            buffer.append(lineCount++ > 1 ? indent : EMPTY_STRING);
            buffer.append(line.substring(0, spaceIndex));
            buffer.append(LINE_SEPARATOR);
            line = line.substring(spaceIndex + 1);
        }
        buffer.append(lineCount > 1 ? indent : EMPTY_STRING);
        buffer.append(line);
        return buffer.toString();
    }

    public static String forceToString(Object o) {
        try {
            return StringUtils.objectToString(o, true, MAX_ARRAY_ELEMENTS_TO_CONVERT);
        }
        catch (RuntimeException ex) {
            return "Conversion to a string failed because " + ex;
        }
    }

    public static String objectToString(Object o, boolean convertArrayContents, int maxArrayElements) {
        if (o == null || o == Token.NOT_AVAILABLE) {
            return "null";
        }
        if (o instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)o;
            return cd.getStringForm();
        }
        if (convertArrayContents && o.getClass().isArray()) {
            Class<?> eClass = o.getClass();
            if (eClass == byte[].class) {
                return StringUtils.arrayToString((byte[])o, maxArrayElements);
            }
            if (eClass == boolean[].class) {
                return StringUtils.arrayToString((boolean[])o, maxArrayElements);
            }
            if (eClass == char[].class) {
                return StringUtils.arrayToString((char[])o, maxArrayElements);
            }
            if (eClass == short[].class) {
                return StringUtils.arrayToString((short[])o, maxArrayElements);
            }
            if (eClass == int[].class) {
                return StringUtils.arrayToString((int[])o, maxArrayElements);
            }
            if (eClass == long[].class) {
                return StringUtils.arrayToString((long[])o, maxArrayElements);
            }
            if (eClass == float[].class) {
                return StringUtils.arrayToString((float[])o, maxArrayElements);
            }
            if (eClass == double[].class) {
                return StringUtils.arrayToString((double[])o, maxArrayElements);
            }
            return StringUtils.arrayToString((Object[])o, maxArrayElements);
        }
        return o.toString();
    }

    private static String arrayToString(Object[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        Class<?> componentType = a.getClass().getComponentType();
        if (--iMax == -1) {
            return componentType.getSimpleName() + "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append(componentType.getSimpleName());
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(boolean[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "boolean[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("boolean[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(byte[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "byte[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("byte[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(char[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "char[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("char[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(short[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "short[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("short[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(int[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "int[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("int[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(long[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "long[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("long[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(float[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "float[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("float[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String arrayToString(double[] a, int maxArrayElements) {
        if (maxArrayElements < 0) {
            maxArrayElements = 0;
        }
        if (a == null) {
            return "null";
        }
        int iMax = a.length;
        if (iMax > maxArrayElements) {
            iMax = maxArrayElements;
        }
        if (--iMax == -1) {
            return "double[]";
        }
        StringBuilder b = new StringBuilder();
        b.append("double[");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                int skipCount = a.length - maxArrayElements;
                if (skipCount > 0) {
                    if (i > 0) {
                        b.append(", ");
                    }
                    b.append("and ");
                    b.append(skipCount);
                    b.append(" more");
                }
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

