/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.i18n;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.ClassPathLoader;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class AbstractStringIdResourceBundle {
    private Int2ObjectOpenHashMap data;
    private static AbstractStringIdResourceBundle messageBundle;

    private void initData(String baseName, Locale l) {
        StringBuffer sb = new StringBuffer(baseName);
        sb.append("_").append(l.getLanguage()).append(".txt");
        String resource = sb.toString();
        InputStream is = null;
        try {
            is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), resource);
        }
        catch (SecurityException se) {
            System.err.println("A SecurityException occurred while attempting to load the resource bundle, defaulting to English." + se.toString());
            se.printStackTrace();
            System.err.flush();
        }
        this.data = is == null ? null : this.readDataFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Int2ObjectOpenHashMap readDataFile(InputStream is) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        boolean complete = false;
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = input.readLine()) != null) {
                int equalSign = line.indexOf(61);
                String idAsString = line.substring(0, equalSign - 1).trim();
                String message = line.substring(equalSign + 2).replaceAll("\\\\n", "\n");
                try {
                    int id = Integer.parseInt(idAsString);
                    map.put(id, (Object)message);
                }
                catch (NumberFormatException nfe) {
                    throw new InternalGemFireException(nfe);
                }
                complete = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (!complete) {
                try {
                    if (input != null) {
                        input.close();
                    } else {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                map = null;
            }
        }
        return map;
    }

    private AbstractStringIdResourceBundle() {
    }

    public String getString(StringId key) {
        if (this.usingRawMode()) {
            return key.getRawText();
        }
        String txt = (String)this.data.get(key.id);
        if (txt != null) {
            return txt;
        }
        return key.getRawText();
    }

    public boolean usingRawMode() {
        return this.data == null;
    }

    public static AbstractStringIdResourceBundle getBundle(String baseName, Locale l) {
        AbstractStringIdResourceBundle newMessageBundle = new AbstractStringIdResourceBundle();
        newMessageBundle.initData(baseName, l);
        messageBundle = newMessageBundle;
        return messageBundle;
    }
}

