/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.datasource;

import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.datasource.AbstractDataSource;
import com.gemstone.gemfire.internal.datasource.ConfiguredDataSourceProperties;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GemFireBasicDataSource
extends AbstractDataSource {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4010116024816908360L;
    protected transient Driver driverObject = null;

    public boolean isWrapperFor(Class iface) throws SQLException {
        return true;
    }

    public Object unwrap(Class iface) throws SQLException {
        return iface;
    }

    public GemFireBasicDataSource(ConfiguredDataSourceProperties configs) throws SQLException {
        super(configs);
        this.loadDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = null;
        if (this.driverObject == null) {
            GemFireBasicDataSource gemFireBasicDataSource = this;
            synchronized (gemFireBasicDataSource) {
                if (this.driverObject == null) {
                    this.loadDriver();
                }
            }
        }
        if (this.url == null) {
            StringId exception = LocalizedStrings.GemFireBasicDataSource_GEMFIREBASICDATASOURCE_GETCONNECTION_URL_FOR_THE_DATASOURCE_NOT_AVAILABLE;
            logger.info((Message)LocalizedMessage.create(exception));
            throw new SQLException(exception.toLocalizedString());
        }
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", this.password);
        connection = this.driverObject.connect(this.url, props);
        return connection;
    }

    @Override
    public Connection getConnection(String clUsername, String clPassword) throws SQLException {
        this.checkCredentials(clUsername, clPassword);
        return this.getConnection();
    }

    private void loadDriver() throws SQLException {
        try {
            Class<?> driverClass = ClassPathLoader.getLatest().forName(this.jdbcDriver);
            this.driverObject = (Driver)driverClass.newInstance();
        }
        catch (Exception ex) {
            StringId msg = LocalizedStrings.GemFireBasicDataSource_AN_EXCEPTION_WAS_CAUGHT_WHILE_TRYING_TO_LOAD_THE_DRIVER;
            String msgArg = ex.getLocalizedMessage();
            logger.error((Message)LocalizedMessage.create(msg, msgArg), (Throwable)ex);
            throw new SQLException(msg.toLocalizedString(msgArg));
        }
    }
}

