/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.concurrent;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.LocalStatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.StatisticsTypeImpl;
import com.gemstone.gemfire.internal.stats50.Atomic50StatisticsImpl;
import java.util.concurrent.atomic.AtomicLong;

public class Atomics {
    private static final boolean STRIPED_STATS_DISABLED = Boolean.getBoolean("gemfire.STRIPED_STATS_DISABLED") || "IBM Corporation".equals(System.getProperty("java.vm.vendor", "unknown"));

    private Atomics() {
    }

    public static Statistics createAtomicStatistics(StatisticsType type, String textId, long nId, long uId, StatisticsManager mgr) {
        StatisticsImpl result = null;
        result = ((StatisticsTypeImpl)type).getDoubleStatCount() == 0 && !STRIPED_STATS_DISABLED ? new Atomic50StatisticsImpl(type, textId, nId, uId, mgr) : new LocalStatisticsImpl(type, textId, nId, uId, true, 0, mgr);
        return result;
    }

    public static boolean setIfGreater(AtomicLong atom, long update) {
        long cur;
        while (update > (cur = atom.get())) {
            if (!atom.compareAndSet(cur, update)) continue;
            return true;
        }
        return false;
    }
}

