/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlPropertyResolverHelper;
import com.gemstone.gemfire.internal.cache.xmlcache.PropertyResolver;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.HashSet;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class CacheXmlPropertyResolver
implements PropertyResolver {
    private static final Logger logger = LogService.getLogger();
    private boolean ignoreUnresolvedProperties = false;
    private int propertyOverridden = 0;
    private CacheXmlPropertyResolverHelper helper = null;
    private Properties props = null;

    public CacheXmlPropertyResolver(boolean ignoreUnresolvedProperties, int propertyOverridden, Properties props) {
        this.ignoreUnresolvedProperties = ignoreUnresolvedProperties;
        this.propertyOverridden = propertyOverridden;
        this.props = props;
    }

    @Override
    public int getPropertyOverridden() {
        return this.propertyOverridden;
    }

    public void setPropertyOverridden(int propertyOverridden) {
        this.propertyOverridden = propertyOverridden;
    }

    public void setIgnoreUnresolvedProperties(boolean ignoreUnresolvedProperties) {
        this.ignoreUnresolvedProperties = ignoreUnresolvedProperties;
    }

    @Override
    public boolean isIgnoreUnresolvedProperties() {
        return this.ignoreUnresolvedProperties;
    }

    @Override
    public String resolveReplaceString(String replaceString) {
        String userDefined;
        String replacement = null;
        replacement = System.getProperty(replaceString);
        if ((replacement == null || this.getPropertyOverridden() == 0) && this.props != null && (userDefined = this.props.getProperty(replaceString)) != null) {
            replacement = userDefined;
        }
        return replacement;
    }

    @Override
    public String processUnresolvableString(String stringWithPrefixAndSuffix, String prefix, String suffix) {
        String resolvedString;
        block3: {
            resolvedString = null;
            try {
                if (this.helper == null) {
                    this.helper = new CacheXmlPropertyResolverHelper(prefix, suffix);
                }
                resolvedString = this.helper.parseResolvablePropString(stringWithPrefixAndSuffix, this, new HashSet<String>());
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreUnresolvedProperties) break block3;
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.CacheXmlPropertyResolver_UNSEROLVAVLE_STRING_FORMAT_ERROR__0, stringWithPrefixAndSuffix));
            }
        }
        return resolvedString;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    @Override
    public String processUnresolvableString(String stringWithPrefixAndSuffix) {
        return this.processUnresolvableString(stringWithPrefixAndSuffix, null, null);
    }
}

