/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.wan.EventSequenceID;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.ReferenceCountHelper;
import com.gemstone.gemfire.internal.offheap.Releasable;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public class GatewaySenderEventImpl
implements AsyncEvent,
DataSerializableFixedID,
Conflatable,
Sizeable,
Releasable {
    private static final long serialVersionUID = -5690172020872255422L;
    protected static final Object TOKEN_NULL = new Object();
    protected static final short VERSION = 17;
    protected EnumListenerEvent operation;
    protected Object substituteValue;
    protected int action;
    protected int operationDetail;
    protected int numberOfParts;
    protected EventID id;
    private transient LocalRegion region;
    protected String regionPath;
    protected Object key;
    protected byte[] value;
    protected transient Object valueObj;
    protected transient boolean valueObjReleased;
    private transient boolean serializedValueNotAvailable;
    protected byte valueIsObject;
    protected GatewaySenderEventCallbackArgument callbackArgument;
    protected long versionTimeStamp;
    protected boolean possibleDuplicate;
    protected volatile boolean isAcked;
    protected volatile boolean isDispatched;
    protected long creationTime;
    protected int bucketId;
    protected Long shadowKey = -1L;
    protected boolean isInitialized;
    public static final ThreadLocal isSerializingValue = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final int CREATE_ACTION = 0;
    private static final int UPDATE_ACTION = 1;
    private static final int DESTROY_ACTION = 2;
    private static final int VERSION_ACTION = 3;
    private static final int INVALIDATE_ACTION = 5;
    private static final int OP_DETAIL_NONE = 10;
    private static final int OP_DETAIL_LOCAL_LOAD = 11;
    private static final int OP_DETAIL_NET_LOAD = 12;
    private static final int OP_DETAIL_PUTALL = 13;
    private static final int OP_DETAIL_REMOVEALL = 14;
    private static final int DEFAULT_SERIALIZED_VALUE_SIZE = -1;
    private volatile int serializedValueSize = -1;

    public GatewaySenderEventImpl() {
    }

    public GatewaySenderEventImpl(EnumListenerEvent operation, CacheEvent event, Object substituteValue) throws IOException {
        this(operation, event, substituteValue, true);
    }

    public GatewaySenderEventImpl(EnumListenerEvent operation, CacheEvent event, Object substituteValue, boolean initialize, int bucketId) throws IOException {
        this(operation, event, substituteValue, initialize);
        this.bucketId = bucketId;
    }

    public GatewaySenderEventImpl(EnumListenerEvent operation, CacheEvent ce, Object substituteValue, boolean initialize) throws IOException {
        EntryEventImpl event = (EntryEventImpl)ce;
        this.operation = operation;
        this.substituteValue = substituteValue;
        this.region = event.getRegion();
        this.regionPath = this.region.getFullPath();
        this.initializeId(event);
        this.possibleDuplicate = event.isPossibleDuplicate();
        this.isAcked = false;
        this.isDispatched = false;
        this.creationTime = System.currentTimeMillis();
        if (event.getVersionTag() != null) {
            this.versionTimeStamp = event.getVersionTag().getVersionTimeStamp();
        }
        this.key = event.getKey();
        this.initializeValue(event);
        this.callbackArgument = (GatewaySenderEventCallbackArgument)event.getRawCallbackArgument();
        this.initializeAction(this.operation);
        this.initializeOperationDetail(event.getOperation());
        this.setShadowKey(event.getTailKey());
        if (initialize) {
            this.initialize();
        }
    }

    protected GatewaySenderEventImpl(GatewaySenderEventImpl offHeapEvent) {
        this.operation = offHeapEvent.operation;
        this.action = offHeapEvent.action;
        this.numberOfParts = offHeapEvent.numberOfParts;
        this.id = offHeapEvent.id;
        this.region = offHeapEvent.region;
        this.regionPath = offHeapEvent.regionPath;
        this.key = offHeapEvent.key;
        this.callbackArgument = offHeapEvent.callbackArgument;
        this.versionTimeStamp = offHeapEvent.versionTimeStamp;
        this.possibleDuplicate = offHeapEvent.possibleDuplicate;
        this.isAcked = offHeapEvent.isAcked;
        this.isDispatched = offHeapEvent.isDispatched;
        this.creationTime = offHeapEvent.creationTime;
        this.bucketId = offHeapEvent.bucketId;
        this.shadowKey = offHeapEvent.shadowKey;
        this.isInitialized = offHeapEvent.isInitialized;
        this.valueObj = null;
        this.valueObjReleased = false;
        this.valueIsObject = offHeapEvent.valueIsObject;
        this.value = offHeapEvent.getSerializedValue();
    }

    public int getAction() {
        return this.action;
    }

    @Override
    public Operation getOperation() {
        Operation op = null;
        block0 : switch (this.action) {
            case 0: {
                switch (this.operationDetail) {
                    case 11: {
                        op = Operation.LOCAL_LOAD_CREATE;
                        break block0;
                    }
                    case 12: {
                        op = Operation.NET_LOAD_CREATE;
                        break block0;
                    }
                    case 13: {
                        op = Operation.PUTALL_CREATE;
                        break block0;
                    }
                    case 10: {
                        op = Operation.CREATE;
                        break block0;
                    }
                }
                op = Operation.CREATE;
                break;
            }
            case 1: {
                switch (this.operationDetail) {
                    case 11: {
                        op = Operation.LOCAL_LOAD_UPDATE;
                        break block0;
                    }
                    case 12: {
                        op = Operation.NET_LOAD_UPDATE;
                        break block0;
                    }
                    case 13: {
                        op = Operation.PUTALL_UPDATE;
                        break block0;
                    }
                    case 10: {
                        op = Operation.UPDATE;
                        break block0;
                    }
                }
                op = Operation.UPDATE;
                break;
            }
            case 2: {
                if (this.operationDetail == 14) {
                    op = Operation.REMOVEALL_DESTROY;
                    break;
                }
                op = Operation.DESTROY;
                break;
            }
            case 3: {
                op = Operation.UPDATE_VERSION_STAMP;
                break;
            }
            case 5: {
                op = Operation.INVALIDATE;
            }
        }
        return op;
    }

    public Object getSubstituteValue() {
        return this.substituteValue;
    }

    public EnumListenerEvent getEnumListenerEvent() {
        return this.operation;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public Object getKey() {
        return this.isInitialized() ? this.key : null;
    }

    public byte getValueIsObject() {
        return this.valueIsObject;
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.getSenderCallbackArgument();
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        return result;
    }

    public GatewaySenderEventCallbackArgument getSenderCallbackArgument() {
        return this.callbackArgument;
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }

    public Object getValue() {
        if (CachedDeserializableFactory.preferObject()) {
            return this.getDeserializedValue();
        }
        Object rawValue = this.value;
        if (rawValue == null) {
            rawValue = this.substituteValue;
        }
        if (rawValue == null) {
            Object vo = this.valueObj;
            rawValue = vo instanceof StoredObject ? ((StoredObject)vo).getValueAsHeapByteArray() : (Object)vo;
        }
        if (this.valueIsObject == 0) {
            return rawValue;
        }
        if (CachedDeserializableFactory.preferObject()) {
            return rawValue;
        }
        if (rawValue instanceof byte[]) {
            return CachedDeserializableFactory.create(rawValue);
        }
        return rawValue;
    }

    public Object getRawValue() {
        Object result = this.value;
        if (result == null && (result = (Object)this.substituteValue) == null && (result = (Object)this.valueObj) instanceof StoredObject && ((StoredObject)result).hasRefCount()) {
            if (this.valueObjReleased) {
                result = null;
            } else {
                StoredObject ohref = (StoredObject)result;
                if (!ohref.retain()) {
                    result = null;
                } else if (this.valueObjReleased) {
                    ohref.release();
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public Object getDeserializedValue() {
        if (this.valueIsObject == 0) {
            byte[] result = this.value;
            if (result == null) {
                Object so = this.valueObj;
                if (this.valueObjReleased) {
                    throw new IllegalStateException("Value is no longer available. getDeserializedValue must be called before processEvents returns.");
                }
                if (so instanceof StoredObject) {
                    return ((StoredObject)so).getValueAsDeserializedHeapObject();
                }
                throw new IllegalStateException("expected valueObj field to be an instance of StoredObject but it was " + so);
            }
            return result;
        }
        Object vo = this.valueObj;
        if (vo != null) {
            if (vo instanceof StoredObject) {
                StoredObject so = (StoredObject)vo;
                return so.getValueAsDeserializedHeapObject();
            }
            return vo;
        }
        if (this.value != null) {
            Object result;
            this.valueObj = result = EntryEventImpl.deserialize(this.value);
            return result;
        }
        if (this.substituteValue != null) {
            return this.substituteValue;
        }
        if (this.valueObjReleased) {
            throw new IllegalStateException("Value is no longer available. getDeserializedValue must be called before processEvents returns.");
        }
        return null;
    }

    public String getValueAsString(boolean deserialize) {
        Object ov;
        Object v = this.value;
        if (v == null) {
            v = this.substituteValue;
        }
        if (deserialize) {
            try {
                v = this.getDeserializedValue();
            }
            catch (Exception e) {
                return "Could not convert value to string because " + e;
            }
            catch (InternalGemFireError e) {
                return "Could not convert value to string because " + e;
            }
        }
        if (v == null && (ov = this.valueObj) instanceof CachedDeserializable) {
            return ((CachedDeserializable)ov).getStringForm();
        }
        if (v != null) {
            if (v instanceof byte[]) {
                byte[] bav = v;
                return "byte[" + bav.length + "]";
            }
            return v.toString();
        }
        return "";
    }

    public boolean isSerializedValueNotAvailable() {
        return this.serializedValueNotAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSerializedValue() {
        byte[] result = this.value;
        if (result == null) {
            if (this.substituteValue != null) {
                isSerializingValue.set(Boolean.TRUE);
                result = EntryEventImpl.serialize(this.substituteValue);
                isSerializingValue.set(Boolean.FALSE);
                return result;
            }
            Object vo = this.valueObj;
            if (vo instanceof StoredObject) {
                GatewaySenderEventImpl gatewaySenderEventImpl = this;
                synchronized (gatewaySenderEventImpl) {
                    result = this.value;
                    if (result == null) {
                        StoredObject so = (StoredObject)vo;
                        this.value = result = so.getValueAsHeapByteArray();
                    }
                }
            }
            GatewaySenderEventImpl gatewaySenderEventImpl = this;
            synchronized (gatewaySenderEventImpl) {
                result = this.value;
                if (result == null && vo != null && !(vo instanceof Token)) {
                    isSerializingValue.set(Boolean.TRUE);
                    result = EntryEventImpl.serialize(vo);
                    isSerializingValue.set(Boolean.FALSE);
                    this.value = result;
                } else if (result == null && this.valueObjReleased) {
                    this.serializedValueNotAvailable = true;
                    throw new IllegalStateException("Value is no longer available. getSerializedValue must be called before processEvents returns.");
                }
            }
        }
        return result;
    }

    public void setPossibleDuplicate(boolean possibleDuplicate) {
        this.possibleDuplicate = possibleDuplicate;
    }

    @Override
    public boolean getPossibleDuplicate() {
        return this.possibleDuplicate;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getDSFID() {
        return -134;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.initialize();
        out.writeShort(17);
        out.writeInt(this.action);
        out.writeInt(this.numberOfParts);
        DataSerializer.writeObject(this.id, out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeByte(this.valueIsObject);
        this.serializeKey(out);
        DataSerializer.writeByteArray(this.getSerializedValue(), out);
        DataSerializer.writeObject(this.callbackArgument, out);
        out.writeBoolean(this.possibleDuplicate);
        out.writeLong(this.creationTime);
        out.writeInt(this.bucketId);
        out.writeLong(this.shadowKey);
        out.writeLong(this.getVersionTimeStamp());
    }

    protected void serializeKey(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version != 17) {
            // empty if block
        }
        this.isInitialized = true;
        this.action = in.readInt();
        this.numberOfParts = in.readInt();
        if (version < 17 && in instanceof InputStream && InternalDataSerializer.getVersionForDataStream(in) == Version.CURRENT) {
            in = new VersionedDataInputStream((InputStream)((Object)in), Version.GFE_701);
        }
        this.id = (EventID)DataSerializer.readObject(in);
        this.regionPath = DataSerializer.readString(in);
        this.valueIsObject = in.readByte();
        this.deserializeKey(in);
        this.value = DataSerializer.readByteArray(in);
        this.callbackArgument = (GatewaySenderEventCallbackArgument)DataSerializer.readObject(in);
        this.possibleDuplicate = in.readBoolean();
        this.creationTime = in.readLong();
        this.bucketId = in.readInt();
        this.shadowKey = in.readLong();
        this.versionTimeStamp = in.readLong();
    }

    protected void deserializeKey(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readObject(in);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SenderEventImpl[").append("id=").append(this.id).append(";action=").append(this.action).append(";operation=").append(this.getOperation()).append(";region=").append(this.regionPath).append(";key=").append(this.key).append(";value=").append(this.getValueAsString(true)).append(";valueIsObject=").append(this.valueIsObject).append(";numberOfParts=").append(this.numberOfParts).append(";callbackArgument=").append(this.callbackArgument).append(";possibleDuplicate=").append(this.possibleDuplicate).append(";creationTime=").append(this.creationTime).append(";shadowKey= ").append(this.shadowKey).append(";timeStamp=").append(this.versionTimeStamp).append(";acked=").append(this.isAcked).append(";dispatched=").append(this.isDispatched).append("]");
        return buffer.toString();
    }

    public static boolean isSerializingValue() {
        return (Boolean)isSerializingValue.get();
    }

    @Override
    public boolean shouldBeConflated() {
        return this.isUpdate();
    }

    @Override
    public String getRegionToConflate() {
        return this.regionPath;
    }

    @Override
    public Object getKeyToConflate() {
        return this.key;
    }

    @Override
    public Object getValueToConflate() {
        return this.getValueAsString(true);
    }

    @Override
    public void setLatestValue(Object value) {
        throw new UnsupportedOperationException();
    }

    protected boolean isUpdate() {
        return this.operation == null ? this.action == 1 : this.operation == EnumListenerEvent.AFTER_UPDATE;
    }

    protected boolean isCreate() {
        return this.operation == null ? this.action == 0 : this.operation == EnumListenerEvent.AFTER_CREATE;
    }

    protected boolean isDestroy() {
        return this.operation == null ? this.action == 2 : this.operation == EnumListenerEvent.AFTER_DESTROY;
    }

    private void initializeId(EntryEventImpl event) {
        this.id = event.getEventId();
        if (this.id == null) {
            throw new IllegalStateException(LocalizedStrings.GatewayEventImpl_NO_EVENT_ID_IS_AVAILABLE_FOR_THIS_GATEWAY_EVENT.toLocalizedString());
        }
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.isInitialized = true;
    }

    protected void initializeValue(EntryEventImpl event) throws IOException {
        if (this.substituteValue == null) {
            this.valueIsObject = 1;
            StoredObject so = null;
            if (event.hasDelta()) {
                this.valueIsObject = (byte)2;
            } else {
                ReferenceCountHelper.setReferenceCountOwner(this);
                so = event.getOffHeapNewValue();
                ReferenceCountHelper.setReferenceCountOwner(null);
            }
            if (so != null) {
                so = so.getStoredObjectWithoutHeapForm();
                this.valueObj = so;
                if (!so.isSerialized()) {
                    this.valueIsObject = 0;
                }
            } else if (event.getCachedSerializedNewValue() != null) {
                this.value = event.getCachedSerializedNewValue();
            } else {
                Object newValue = event.getRawNewValue(this.shouldApplyDelta());
                assert (!(newValue instanceof StoredObject));
                if (newValue instanceof CachedDeserializable) {
                    this.value = ((CachedDeserializable)newValue).getSerializedValue();
                } else if (newValue instanceof byte[]) {
                    this.value = (byte[])newValue;
                    this.valueIsObject = 0;
                } else {
                    this.valueObj = newValue;
                    this.getSerializedValue();
                    this.valueObj = null;
                }
            }
        } else if (this.substituteValue instanceof byte[]) {
            this.value = (byte[])this.substituteValue;
            this.valueIsObject = 0;
        } else if (this.substituteValue == TOKEN_NULL) {
            this.value = null;
            this.substituteValue = null;
            this.valueIsObject = 1;
        } else {
            this.valueIsObject = 1;
        }
    }

    protected boolean shouldApplyDelta() {
        return false;
    }

    protected void initializeAction(EnumListenerEvent operation) {
        if (operation == EnumListenerEvent.AFTER_CREATE) {
            this.action = 0;
            this.numberOfParts = this.callbackArgument == null ? 8 : 9;
        } else if (operation == EnumListenerEvent.AFTER_UPDATE) {
            this.action = 1;
            this.numberOfParts = this.callbackArgument == null ? 8 : 9;
        } else if (operation == EnumListenerEvent.AFTER_DESTROY) {
            this.action = 2;
            this.numberOfParts = this.callbackArgument == null ? 7 : 8;
        } else if (operation == EnumListenerEvent.TIMESTAMP_UPDATE) {
            this.action = 3;
            this.numberOfParts = this.callbackArgument == null ? 7 : 8;
        } else if (operation == EnumListenerEvent.AFTER_INVALIDATE) {
            this.action = 5;
            this.numberOfParts = this.callbackArgument == null ? 7 : 8;
        }
    }

    private void initializeOperationDetail(Operation operation) {
        this.operationDetail = operation.isLocalLoad() ? 11 : (operation.isNetLoad() ? 12 : (operation.isPutAll() ? 13 : (operation.isRemoveAll() ? 14 : 10)));
    }

    @Override
    public EventID getEventId() {
        return this.id;
    }

    @Override
    public EventSequenceID getEventSequenceID() {
        return new EventSequenceID(this.id.getMembershipID(), this.id.getThreadID(), this.id.getSequenceID());
    }

    public long getVersionTimeStamp() {
        return this.versionTimeStamp;
    }

    @Override
    public int getSizeInBytes() {
        int size = 0;
        size += 8;
        size += 28;
        size += 30;
        size += 64;
        size += this.getSerializedValueSize();
        size += 202;
        size += 8 + this.sizeOf(this.getCallbackArgument());
        return size += 8;
    }

    private int sizeOf(Object obj) {
        int size = 0;
        if (obj == null) {
            return size;
        }
        size = obj instanceof String ? ObjectSizer.DEFAULT.sizeof(obj) : (obj instanceof Integer ? 4 : (obj instanceof Long ? 8 : CachedDeserializableFactory.calcMemSize(obj) - 8));
        return size;
    }

    @Override
    public Region<?, ?> getRegion() {
        return this.region != null ? this.region : CacheFactory.getAnyInstance().getRegion(this.regionPath);
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setShadowKey(Long tailKey) {
        this.shadowKey = tailKey;
    }

    public Long getShadowKey() {
        return this.shadowKey;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public int getSerializedValueSize() {
        int localSerializedValueSize = this.serializedValueSize;
        if (localSerializedValueSize != -1) {
            return localSerializedValueSize;
        }
        Object vo = this.valueObj;
        localSerializedValueSize = vo instanceof StoredObject ? ((StoredObject)vo).getSizeInBytes() : (this.substituteValue != null ? this.sizeOf(this.substituteValue) : CachedDeserializableFactory.calcMemSize(this.getSerializedValue()));
        this.serializedValueSize = localSerializedValueSize;
        return localSerializedValueSize;
    }

    @Override
    public void release() {
        Object vo = this.valueObj;
        if (OffHeapHelper.releaseAndTrackOwner(vo, this)) {
            this.valueObj = null;
            this.valueObjReleased = true;
        }
    }

    public static void release(Object o) {
        if (o instanceof GatewaySenderEventImpl) {
            ((GatewaySenderEventImpl)o).release();
        }
    }

    public GatewaySenderEventImpl makeHeapCopyIfOffHeap() {
        if (this.value != null || this.substituteValue != null) {
            return this;
        }
        Object v = this.valueObj;
        if (v == null) {
            if (this.valueObjReleased) {
                return null;
            }
            return this;
        }
        if (v instanceof StoredObject && ((StoredObject)v).hasRefCount()) {
            try {
                return this.makeCopy();
            }
            catch (IllegalStateException ex) {
                return null;
            }
        }
        return this;
    }

    protected GatewaySenderEventImpl makeCopy() {
        return new GatewaySenderEventImpl(this);
    }

    public void copyOffHeapValue() {
        if (this.value == null) {
            this.value = this.getSerializedValue();
        }
    }
}

