/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractGatewaySenderEventProcessor
extends Thread {
    private static final Logger logger = LogService.getLogger();
    public static boolean TEST_HOOK = false;
    protected RegionQueue queue;
    protected GatewaySenderEventDispatcher dispatcher;
    protected final AbstractGatewaySender sender;
    protected int batchId = 0;
    private volatile boolean isStopped = true;
    protected volatile boolean isPaused = false;
    protected boolean isDispatcherWaiting = false;
    protected final Object pausedLock = new Object();
    public final Object runningStateLock = new Object();
    protected boolean eventQueueSizeWarning = false;
    private Exception exception;
    private Map<Integer, List<GatewaySenderEventImpl>[]> batchIdToEventsMap = Collections.synchronizedMap(new HashMap());
    private Map<Integer, List<GatewaySenderEventImpl>> batchIdToPDXEventsMap = Collections.synchronizedMap(new HashMap());
    private List<GatewaySenderEventImpl> pdxSenderEventsList = new ArrayList<GatewaySenderEventImpl>();
    private Map<Object, GatewaySenderEventImpl> pdxEventsMap = new HashMap<Object, GatewaySenderEventImpl>();
    private volatile boolean rebuildPdxList = false;
    private volatile boolean resetLastPeekedEvents;
    private long numEventsDispatched;
    private int batchSize;
    private final ConcurrentHashMap<Integer, long[]> failureLogInterval = new ConcurrentHashMap();
    protected static final int FAILURE_MAP_MAXSIZE = Integer.getInteger("gemfire.GatewaySender.FAILURE_MAP_MAXSIZE", 1000000);
    protected static final int FAILURE_LOG_MAX_INTERVAL = Integer.getInteger("gemfire.GatewaySender.FAILURE_LOG_MAX_INTERVAL", 300000);

    public AbstractGatewaySenderEventProcessor(LoggingThreadGroup createThreadGroup, String string, GatewaySender sender) {
        super((ThreadGroup)createThreadGroup, string);
        this.sender = (AbstractGatewaySender)sender;
        this.batchSize = sender.getBatchSize();
    }

    protected abstract void initializeMessageQueue(String var1);

    public abstract void enqueueEvent(EnumListenerEvent var1, EntryEvent var2, Object var3) throws IOException, CacheException;

    protected abstract void rebalance();

    public boolean isStopped() {
        return this.isStopped;
    }

    protected void setIsStopped(boolean isStopped) {
        if (isStopped) {
            this.isStopped = true;
            this.failureLogInterval.clear();
        } else {
            this.isStopped = isStopped;
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public RegionQueue getQueue() {
        return this.queue;
    }

    public void incrementBatchId() {
        if (this.batchId + 1 == Integer.MAX_VALUE) {
            this.batchId = -1;
        }
        ++this.batchId;
    }

    protected void resetBatchId() {
        this.batchId = 0;
        this.resetLastPeekedEvents = true;
    }

    protected int getBatchSize() {
        return this.batchSize;
    }

    protected void setBatchSize(int batchSize) {
        int currentBatchSize = this.batchSize;
        if (batchSize <= 0) {
            this.batchSize = 1;
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.AbstractGatewaySenderEventProcessor_ATTEMPT_TO_SET_BATCH_SIZE_FAILED, new Object[]{currentBatchSize, batchSize}));
        } else {
            this.batchSize = batchSize;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AbstractGatewaySenderEventProcessor_SET_BATCH_SIZE, new Object[]{currentBatchSize, this.batchSize}));
        }
    }

    protected int getBatchId() {
        return this.batchId;
    }

    protected boolean isConnectionReset() {
        return this.resetLastPeekedEvents;
    }

    protected void eventQueueRemove() throws CacheException, InterruptedException {
        this.queue.remove();
    }

    protected void eventQueueRemove(int size) throws CacheException {
        this.queue.remove(size);
    }

    protected Object eventQueueTake() throws CacheException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public int eventQueueSize() {
        if (this.queue == null) {
            return 0;
        }
        if (this.queue instanceof ParallelGatewaySenderQueue) {
            return ((ParallelGatewaySenderQueue)this.queue).localSize();
        }
        if (this.queue instanceof ConcurrentParallelGatewaySenderQueue) {
            return ((ConcurrentParallelGatewaySenderQueue)this.queue).localSize();
        }
        return this.queue.size();
    }

    public AbstractGatewaySender getSender() {
        return this.sender;
    }

    public void pauseDispatching() {
        if (this.isPaused) {
            return;
        }
        this.isPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDispatcherToPause() {
        if (!this.isPaused) {
            throw new IllegalStateException("Should be trying to pause!");
        }
        boolean interrupted = false;
        Object object = this.pausedLock;
        synchronized (object) {
            while (!this.isDispatcherWaiting && !this.isStopped() && this.sender.getSenderAdvisor().isPrimary()) {
                try {
                    this.pausedLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDispatching() {
        if (!this.isPaused) {
            return;
        }
        this.isPaused = false;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Resumed dispatching", new Object[]{this});
        }
        Object object = this.pausedLock;
        synchronized (object) {
            this.pausedLock.notifyAll();
        }
    }

    protected boolean stopped() {
        if (this.isStopped) {
            return true;
        }
        return this.sender.getStopper().cancelInProgress() != null;
    }

    public final boolean skipFailureLogging(Integer batchId) {
        boolean skipLogging = false;
        if (this.failureLogInterval.size() < FAILURE_MAP_MAXSIZE) {
            long[] logInterval = this.failureLogInterval.get(batchId);
            if (logInterval == null) {
                logInterval = this.failureLogInterval.putIfAbsent(batchId, new long[]{System.currentTimeMillis(), 1000L});
            }
            if (logInterval != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - logInterval[0] < logInterval[1]) {
                    skipLogging = true;
                } else {
                    logInterval[0] = currentTime;
                    if (logInterval[1] <= (long)(FAILURE_LOG_MAX_INTERVAL / 4)) {
                        logInterval[1] = logInterval[1] * 4L;
                    }
                }
            }
        }
        return skipLogging;
    }

    public final boolean removeEventFromFailureMap(Integer batchId) {
        return this.failureLogInterval.remove(batchId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueue() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean isTraceEnabled = logger.isTraceEnabled();
        int batchTimeInterval = this.sender.getBatchTimeInterval();
        GatewaySenderStats statistics = this.sender.getStatistics();
        if (isDebugEnabled) {
            logger.debug("STARTED processQueue {}", new Object[]{this.getId()});
        }
        List events = null;
        ArrayList filteredList = new ArrayList();
        List<Object> pdxEventsToBeDispatched = new ArrayList();
        ArrayList<GatewaySenderEventImpl> eventsToBeDispatched = new ArrayList<GatewaySenderEventImpl>();
        block12: while (!this.stopped()) {
            try {
                if (this.isPaused) {
                    this.waitForResumption();
                }
                if (isDebugEnabled) {
                    logger.debug("Attempting to peek a batch of {} events", new Object[]{this.batchSize});
                }
                while (true) {
                    boolean success;
                    if (this.stopped()) {
                        if (!isDebugEnabled) continue block12;
                        logger.debug("GatewaySenderEventProcessor is stopped. Returning without peeking events.");
                        continue block12;
                    }
                    if (this.isPaused) {
                        this.waitForResumption();
                    }
                    boolean sendUpdateVersionEvents = this.shouldSendVersionEvents(this.dispatcher);
                    boolean interrupted = Thread.interrupted();
                    try {
                        if (this.resetLastPeekedEvents) {
                            this.resetLastPeekedEvents();
                            this.resetLastPeekedEvents = false;
                        }
                        events = this.queue.peek(this.batchSize, batchTimeInterval);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this.sender.getCancelCriterion().checkCancelInProgress(e);
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (events.isEmpty()) continue;
                    filteredList = new ArrayList();
                    filteredList.addAll(events);
                    if (this.exception != null && this.exception.getCause() != null && this.exception.getCause() instanceof IllegalStateException) {
                        Iterator<GatewayEventFilter> i = filteredList.iterator();
                        while (i.hasNext()) {
                            GatewaySenderEventImpl event = (GatewaySenderEventImpl)((Object)i.next());
                            if (!event.isSerializedValueNotAvailable()) continue;
                            i.remove();
                        }
                        this.exception = null;
                    }
                    for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
                        Iterator itr = filteredList.iterator();
                        while (itr.hasNext()) {
                            GatewayQueueEvent gatewayQueueEvent = (GatewayQueueEvent)itr.next();
                            if (!sendUpdateVersionEvents && gatewayQueueEvent.getOperation() == Operation.UPDATE_VERSION_STAMP) {
                                if (isTraceEnabled) {
                                    logger.trace("Update Event Version event: {} removed from Gateway Sender queue: {}", new Object[]{gatewayQueueEvent, this.sender});
                                }
                                itr.remove();
                                statistics.incEventsNotQueued();
                                continue;
                            }
                            boolean transmit = filter.beforeTransmit(gatewayQueueEvent);
                            if (transmit) continue;
                            if (isDebugEnabled) {
                                logger.debug("{}: Did not transmit event due to filtering: {}", new Object[]{this.sender.getId(), gatewayQueueEvent});
                            }
                            itr.remove();
                            statistics.incEventsFiltered();
                        }
                    }
                    if (this.getSender().isParallel() && this.getDispatcher() instanceof GatewaySenderEventCallbackDispatcher) {
                        for (GatewaySenderEventImpl event : filteredList) {
                            BucketRegion bucket;
                            Object qpr = null;
                            qpr = this.getQueue() instanceof ConcurrentParallelGatewaySenderQueue ? ((ConcurrentParallelGatewaySenderQueue)this.getQueue()).getRegion(event.getRegionPath()) : ((ParallelGatewaySenderQueue)this.getQueue()).getRegion(event.getRegionPath());
                            int n = event.getBucketId();
                            if (!(qpr == null || (bucket = ((PartitionedRegion)qpr).getDataStore().getLocalBucketById(n)) != null && bucket.getBucketAdvisor().isPrimary())) {
                                event.setPossibleDuplicate(true);
                            }
                            if (!isDebugEnabled) continue;
                            logger.debug("Bucket id: {} is no longer primary on this node. The event {} will be dispatched from this node with possibleDuplicate set to true.", new Object[]{n, event});
                        }
                    }
                    eventsToBeDispatched.clear();
                    if (!(this.dispatcher instanceof GatewaySenderEventCallbackDispatcher)) {
                        List[] eventsArr = new List[]{events, filteredList};
                        this.batchIdToEventsMap.put(this.getBatchId(), eventsArr);
                        pdxEventsToBeDispatched = this.addPDXEvent();
                        eventsToBeDispatched.addAll(pdxEventsToBeDispatched);
                        if (!pdxEventsToBeDispatched.isEmpty()) {
                            this.batchIdToPDXEventsMap.put(this.getBatchId(), pdxEventsToBeDispatched);
                        }
                    }
                    eventsToBeDispatched.addAll(filteredList);
                    List conflatedEventsToBeDispatched = this.conflate(eventsToBeDispatched);
                    if (isDebugEnabled) {
                        this.logBatchFine("During normal processing, dispatching the following ", conflatedEventsToBeDispatched);
                    }
                    if (success = this.dispatcher.dispatchBatch(conflatedEventsToBeDispatched, false)) {
                        if (isDebugEnabled) {
                            logger.debug("During normal processing, successfully dispatched {} events (batch #{})", new Object[]{conflatedEventsToBeDispatched.size(), this.getBatchId()});
                        }
                        this.removeEventFromFailureMap(this.getBatchId());
                    } else if (!this.skipFailureLogging(this.getBatchId())) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_QUEUE_DISPATCH_FAILED, new Object[]{filteredList.size(), this.getBatchId()}));
                    }
                    if (this.stopped()) continue block12;
                    if (success) {
                        if (this.dispatcher instanceof GatewaySenderEventCallbackDispatcher) {
                            this.handleSuccessfulBatchDispatch(conflatedEventsToBeDispatched, events);
                        } else {
                            this.incrementBatchId();
                        }
                        for (GatewaySenderEventImpl gatewaySenderEventImpl : pdxEventsToBeDispatched) {
                            gatewaySenderEventImpl.isDispatched = true;
                        }
                        if (TEST_HOOK) {
                            this.numEventsDispatched += (long)conflatedEventsToBeDispatched.size();
                        }
                    } else if (this.dispatcher instanceof GatewaySenderEventCallbackDispatcher) {
                        this.handleUnSuccessfulBatchDispatch(events);
                        this.resetLastPeekedEvents = true;
                    } else {
                        this.handleUnSuccessfulBatchDispatch(events);
                        if (!this.resetLastPeekedEvents) {
                            while (!this.dispatcher.dispatchBatch(conflatedEventsToBeDispatched, true)) {
                                if (isDebugEnabled) {
                                    logger.debug("During normal processing, unsuccessfully dispatched {} events (batch #{})", new Object[]{conflatedEventsToBeDispatched.size(), this.getBatchId()});
                                }
                                if (this.stopped() || this.resetLastPeekedEvents) break;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            this.incrementBatchId();
                        }
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Finished processing events (batch #{})", new Object[]{this.getBatchId() - 1});
                }
            }
            catch (RegionDestroyedException e) {
                this.resetLastPeekedEvents = true;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Observed RegionDestroyedException on Queue's region.");
            }
            catch (CancelException e) {
                logger.debug("Caught cancel exception", (Throwable)e);
                this.setIsStopped(true);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                Throwable cause;
                SystemFailure.checkFailure();
                if (this.stopped()) {
                    return;
                }
                if (events != null) {
                    this.handleUnSuccessfulBatchDispatch(events);
                }
                this.resetLastPeekedEvents = true;
                if (e instanceof GatewaySenderException && ((cause = e.getCause()) instanceof IOException || e instanceof GatewaySenderConfigurationException)) continue;
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_AN_EXCEPTION_OCCURRED_THE_DISPATCHER_WILL_CONTINUE), e);
            }
        }
    }

    private boolean shouldSendVersionEvents(GatewaySenderEventDispatcher dispatcher) {
        return false;
    }

    private List conflate(List<GatewaySenderEventImpl> events) {
        List<GatewaySenderEventImpl> conflatedEvents = null;
        if (this.sender.isBatchConflationEnabled() && events.size() > 1) {
            LinkedHashMap<ConflationKey, GatewaySenderEventImpl> conflatedEventsMap = new LinkedHashMap<ConflationKey, GatewaySenderEventImpl>();
            conflatedEvents = new ArrayList<GatewaySenderEventImpl>();
            for (GatewaySenderEventImpl gsEvent : events) {
                ConflationKey key;
                if (gsEvent.shouldBeConflated()) {
                    key = new ConflationKey(gsEvent.getRegion().getFullPath(), gsEvent.getKeyToConflate(), gsEvent.getOperation());
                    conflatedEventsMap.remove(key);
                    conflatedEventsMap.put(key, gsEvent);
                    continue;
                }
                key = new ConflationKey(gsEvent.getRegion().getFullPath(), gsEvent.getKeyToConflate(), gsEvent.getOperation());
                conflatedEventsMap.put(key, gsEvent);
            }
            for (GatewaySenderEventImpl gei : conflatedEventsMap.values()) {
                conflatedEvents.add(gei);
            }
            this.sender.getStatistics().incEventsConflatedFromBatches(events.size() - conflatedEvents.size());
        } else {
            conflatedEvents = events;
        }
        return conflatedEvents;
    }

    private List<GatewaySenderEventImpl> addPDXEvent() throws IOException {
        ArrayList<GatewaySenderEventImpl> pdxEventsToBeDispatched = new ArrayList<GatewaySenderEventImpl>();
        GemFireCacheImpl cache = (GemFireCacheImpl)this.sender.getCache();
        Region pdxRegion = cache.getRegion("PdxTypes");
        if (this.rebuildPdxList) {
            this.pdxEventsMap.clear();
            this.pdxSenderEventsList.clear();
            this.rebuildPdxList = false;
        }
        if (pdxRegion != null && pdxRegion.size() != this.pdxEventsMap.size()) {
            for (Map.Entry typeEntry : pdxRegion.entrySet()) {
                if (this.pdxEventsMap.containsKey(typeEntry.getKey())) continue;
                EntryEventImpl event = EntryEventImpl.create((LocalRegion)pdxRegion, Operation.UPDATE, typeEntry.getKey(), typeEntry.getValue(), null, false, cache.getMyId());
                event.setEventId(new EventID(cache.getSystem()));
                ArrayList<Integer> allRemoteDSIds = new ArrayList<Integer>();
                for (GatewaySender sender : cache.getGatewaySenders()) {
                    allRemoteDSIds.add(sender.getRemoteDSId());
                }
                GatewaySenderEventCallbackArgument geCallbackArg = new GatewaySenderEventCallbackArgument(event.getRawCallbackArgument(), this.sender.getMyDSId(), allRemoteDSIds, true);
                event.setCallbackArgument(geCallbackArg);
                GatewaySenderEventImpl pdxSenderEvent = new GatewaySenderEventImpl(EnumListenerEvent.AFTER_UPDATE, event, null);
                this.pdxEventsMap.put(typeEntry.getKey(), pdxSenderEvent);
                this.pdxSenderEventsList.add(pdxSenderEvent);
            }
        }
        Iterator<GatewaySenderEventImpl> iterator = this.pdxSenderEventsList.iterator();
        while (iterator.hasNext()) {
            GatewaySenderEventImpl pdxEvent = iterator.next();
            if (pdxEvent.isAcked) {
                iterator.remove();
                continue;
            }
            if (pdxEvent.isDispatched) continue;
            pdxEventsToBeDispatched.add(pdxEvent);
        }
        if (!pdxEventsToBeDispatched.isEmpty() && logger.isDebugEnabled()) {
            logger.debug("List of PDX Event to be dispatched : {}", new Object[]{pdxEventsToBeDispatched});
        }
        return pdxEventsToBeDispatched;
    }

    public void checkIfPdxNeedsResend(int remotePdxSize) {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.sender.getCache();
        Region pdxRegion = cache.getRegion("PdxTypes");
        if (pdxRegion != null && pdxRegion.size() > remotePdxSize) {
            this.rebuildPdxList = true;
        }
    }

    private void resetLastPeekedEvents() {
        this.batchIdToEventsMap.clear();
        for (Map.Entry<Integer, List<GatewaySenderEventImpl>> entry : this.batchIdToPDXEventsMap.entrySet()) {
            for (GatewaySenderEventImpl event : entry.getValue()) {
                event.isDispatched = false;
            }
        }
        this.batchIdToPDXEventsMap.clear();
        if (this.queue instanceof SerialGatewaySenderQueue) {
            ((SerialGatewaySenderQueue)this.queue).resetLastPeeked();
        } else if (this.queue instanceof ParallelGatewaySenderQueue) {
            ((ParallelGatewaySenderQueue)this.queue).resetLastPeeked();
        } else {
            throw new RuntimeException("resetLastPeekedEvents : no matching queue found " + this);
        }
    }

    private void handleSuccessfulBatchDispatch(List filteredList, List events) {
        if (filteredList != null) {
            for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
                for (Object o : filteredList) {
                    if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
                    try {
                        filter.afterAcknowledgement((GatewaySenderEventImpl)o);
                    }
                    catch (Exception e) {
                        logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GatewayEventFilter_EXCEPTION_OCCURED_WHILE_HANDLING_CALL_TO_0_AFTER_ACKNOWLEDGEMENT_FOR_EVENT_1, new Object[]{filter.toString(), o}), (Throwable)e);
                    }
                }
            }
        }
        filteredList.clear();
        this.eventQueueRemove(events.size());
        GatewaySenderStats statistics = this.sender.getStatistics();
        int queueSize = this.eventQueueSize();
        if (this.sender.getAlertThreshold() > 0) {
            Iterator it = events.iterator();
            long currentTime = System.currentTimeMillis();
            while (it.hasNext()) {
                GatewaySenderEventImpl ge;
                Object o = it.next();
                if (o == null || !(o instanceof GatewaySenderEventImpl) || (ge = (GatewaySenderEventImpl)o).getCreationTime() + (long)this.sender.getAlertThreshold() >= currentTime) continue;
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_QUEUE_ALERT_OPERATION_0_REGION_1_KEY_2_VALUE_3_TIME_4, new Object[]{ge.getOperation(), ge.getRegionPath(), ge.getKey(), ge.getValueAsString(true), currentTime - ge.getCreationTime()}));
                statistics.incEventsExceedingAlertThreshold();
            }
        }
        if (this.eventQueueSizeWarning && queueSize <= AbstractGatewaySender.QUEUE_SIZE_THRESHOLD) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_THE_EVENT_QUEUE_SIZE_HAS_DROPPED_BELOW_THE_THRESHOLD_0, AbstractGatewaySender.QUEUE_SIZE_THRESHOLD));
            this.eventQueueSizeWarning = false;
        }
        this.incrementBatchId();
    }

    private void handleUnSuccessfulBatchDispatch(List events) {
        GatewaySenderStats statistics = this.sender.getStatistics();
        statistics.incBatchesRedistributed();
        Iterator it = events.iterator();
        while (it.hasNext() && !this.isStopped) {
            Object o = it.next();
            if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
            GatewaySenderEventImpl ge = (GatewaySenderEventImpl)o;
            ge.setPossibleDuplicate(true);
        }
    }

    public void handleException() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        statistics.incBatchesRedistributed();
        this.resetLastPeekedEvents = true;
    }

    public void handleSuccessBatchAck(int batchId) {
        List<GatewaySenderEventImpl>[] eventsArr;
        List<GatewaySenderEventImpl> pdxEvents = this.batchIdToPDXEventsMap.remove(batchId);
        if (pdxEvents != null) {
            for (GatewaySenderEventImpl senderEvent : pdxEvents) {
                senderEvent.isAcked = true;
            }
        }
        if ((eventsArr = this.batchIdToEventsMap.remove(batchId)) != null) {
            List<GatewaySenderEventImpl> filteredEvents = eventsArr[1];
            for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
                for (GatewaySenderEventImpl event : filteredEvents) {
                    try {
                        filter.afterAcknowledgement(event);
                    }
                    catch (Exception e) {
                        logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GatewayEventFilter_EXCEPTION_OCCURED_WHILE_HANDLING_CALL_TO_0_AFTER_ACKNOWLEDGEMENT_FOR_EVENT_1, new Object[]{filter.toString(), event}), (Throwable)e);
                    }
                }
            }
            List<GatewaySenderEventImpl> events = eventsArr[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Removing events from the queue {}", new Object[]{events.size()});
            }
            this.eventQueueRemove(events.size());
        }
    }

    public void handleUnSuccessBatchAck(int bId) {
        this.sender.getStatistics().incBatchesRedistributed();
        List<GatewaySenderEventImpl>[] eventsArr = this.batchIdToEventsMap.get(bId);
        if (eventsArr != null) {
            List<GatewaySenderEventImpl> events = eventsArr[0];
            Iterator<GatewaySenderEventImpl> it = events.iterator();
            while (it.hasNext() && !this.isStopped) {
                GatewaySenderEventImpl o = it.next();
                if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
                GatewaySenderEventImpl ge = o;
                ge.setPossibleDuplicate(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResumption() throws InterruptedException {
        Object object = this.pausedLock;
        synchronized (object) {
            if (!this.isPaused) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("GatewaySenderEventProcessor is paused. Waiting for Resumption");
            }
            this.isDispatcherWaiting = true;
            this.pausedLock.notifyAll();
            while (this.isPaused) {
                this.pausedLock.wait();
            }
            this.isDispatcherWaiting = false;
        }
    }

    public abstract void initializeEventDispatcher();

    public GatewaySenderEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Map<Integer, List<GatewaySenderEventImpl>[]> getBatchIdToEventsMap() {
        return this.batchIdToEventsMap;
    }

    public Map<Integer, List<GatewaySenderEventImpl>> getBatchIdToPDXEventsMap() {
        return this.batchIdToPDXEventsMap;
    }

    @Override
    public void run() {
        try {
            this.setRunningStatus();
            this.processQueue();
        }
        catch (CancelException e) {
            if (!this.isStopped()) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_A_CANCELLATION_OCCURRED_STOPPING_THE_DISPATCHER));
                this.setIsStopped(true);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_MESSAGE_DISPATCH_FAILED_DUE_TO_UNEXPECTED_EXCEPTION), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunningStatus() throws Exception {
        GemFireException ex = null;
        try {
            this.initializeEventDispatcher();
        }
        catch (GemFireException e) {
            ex = e;
        }
        Object object = this.runningStateLock;
        synchronized (object) {
            if (ex != null) {
                this.setException(ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.runningStateLock.notifyAll();
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void setException(GemFireException ex) {
        this.exception = ex;
    }

    public Exception getException() {
        return this.exception;
    }

    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        this.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Notifying the dispatcher to terminate", new Object[]{this});
        }
        if (this.sender.isPrimary()) {
            if (AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME == -1) {
                try {
                    while (this.queue.size() != 0) {
                        Thread.sleep(5000L);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("{}: Waiting for the queue to get empty.", new Object[]{this});
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (CancelException cancelException) {}
            } else {
                try {
                    Thread.sleep(AbstractGatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.dispatcher.stop();
        this.setIsStopped(true);
        if (this.isAlive()) {
            this.interrupt();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Joining with the dispatcher thread upto limit of 5 seconds", new Object[]{this});
            }
            try {
                this.join(5000L);
                if (this.isAlive()) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_DISPATCHER_STILL_ALIVE_EVEN_AFTER_JOIN_OF_5_SECONDS, this));
                    this.dispatcher.stop();
                    this.batchIdToEventsMap.clear();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_INTERRUPTEDEXCEPTION_IN_JOINING_WITH_DISPATCHER_THREAD, this));
            }
        }
        this.closeProcessor();
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped dispatching: {}", new Object[]{this});
        }
    }

    public void closeProcessor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing dispatcher");
        }
        try {
            if (this.sender.isPrimary() && this.queue.size() > 0) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_DESTROYING_GATEWAYEVENTDISPATCHER_WITH_ACTIVELY_QUEUED_DATA));
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (CancelException cancelException) {
        }
        catch (CacheException cacheException) {
        }
        finally {
            this.queue.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Closed dispatcher");
            }
        }
    }

    protected void destroyProcessor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying dispatcher");
        }
        try {
            try {
                if (this.queue.peek() != null) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_DESTROYING_GATEWAYEVENTDISPATCHER_WITH_ACTIVELY_QUEUED_DATA));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (CacheException cacheException) {
        }
        finally {
            this.queue.getRegion().localDestroyRegion();
            if (logger.isDebugEnabled()) {
                logger.debug("Destroyed dispatcher");
            }
        }
    }

    public void removeCacheListener() {
    }

    public void logBatchFine(String message, List<GatewaySenderEventImpl> events) {
        if (events != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(message);
            buffer.append(events.size()).append(" events");
            buffer.append(" (batch #" + this.getBatchId());
            buffer.append("):\n");
            for (GatewaySenderEventImpl ge : events) {
                buffer.append("\tEvent ").append(ge.getEventId()).append(":");
                buffer.append(ge.getKey()).append("->");
                buffer.append(ge.getValueAsString(true)).append(",");
                buffer.append(ge.getShadowKey());
                buffer.append("\n");
            }
            logger.debug((Object)buffer);
        }
    }

    public long getNumEventsDispatched() {
        return this.numEventsDispatched;
    }

    public void clear(PartitionedRegion pr, int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).clear(pr, bucketId);
    }

    public void notifyEventProcessorIfRequired(int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).notifyEventProcessorIfRequired();
    }

    public BlockingQueue<GatewaySenderEventImpl> getBucketTmpQueue(int bucketId) {
        return ((ParallelGatewaySenderQueue)this.queue).getBucketToTempQueueMap().get(bucketId);
    }

    public PartitionedRegion getRegion(String prRegionName) {
        return ((ParallelGatewaySenderQueue)this.queue).getRegion(prRegionName);
    }

    public void removeShadowPR(String prRegionName) {
        ((ParallelGatewaySenderQueue)this.queue).removeShadowPR(prRegionName);
    }

    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        ((ParallelGatewaySenderQueue)this.queue).conflateEvent(conflatableObject, bucketId, tailKey);
    }

    public void addShadowPartitionedRegionForUserPR(PartitionedRegion pr) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserPR(pr);
    }

    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserRR(userRegion);
    }

    private static class ConflationKey {
        private Object key;
        private Operation operation;
        private String regionName;

        private ConflationKey(String region, Object key, Operation operation) {
            this.key = key;
            this.operation = operation;
            this.regionName = region;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.operation.hashCode();
            result = 31 * result + this.regionName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConflationKey that = (ConflationKey)obj;
            if (!this.regionName.equals(that.regionName)) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.operation.equals(that.operation);
        }
    }

    protected class SenderStopperCallable
    implements Callable<Boolean> {
        private final AbstractGatewaySenderEventProcessor p;

        public SenderStopperCallable(AbstractGatewaySenderEventProcessor processor) {
            this.p = processor;
        }

        @Override
        public Boolean call() {
            this.p.stopProcessing();
            return true;
        }
    }
}

