/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.versions;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VMVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionHolder;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.logging.log4j.Logger;

public abstract class VersionTag<T extends VersionSource>
implements DataSerializableFixedID,
Serializable,
VersionHolder<T> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 9098338414308465271L;
    public static final int TAG_SIZE = ReflectionSingleObjectSizer.OBJECT_SIZE + ReflectionSingleObjectSizer.REFERENCE_SIZE * 2 + 23;
    public static final long ILLEGAL_VERSION_TIMESTAMP = Long.MIN_VALUE;
    private static final int HAS_MEMBER_ID = 1;
    private static final int HAS_PREVIOUS_MEMBER_ID = 2;
    private static final int VERSION_TWO_BYTES = 4;
    private static final int DUPLICATE_MEMBER_IDS = 8;
    private static final int HAS_RVV_HIGH_BYTE = 16;
    private static final int BITS_POSDUP = 1;
    private static final int BITS_RECORDED = 2;
    private static final int BITS_HAS_PREVIOUS_ID = 4;
    private static final int BITS_GATEWAY_TAG = 8;
    private static final int BITS_IS_REMOTE_TAG = 16;
    private static final int BITS_TIMESTAMP_APPLIED = 32;
    private static final int BITS_ALLOWED_BY_RESOLVER = 64;
    private int entryVersion;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private long timeStamp;
    private byte distributedSystemId;
    private int bits;
    private T memberID;
    private T previousMemberID;

    public boolean isFromOtherMember() {
        return (this.bits & 0x10) != 0;
    }

    public boolean isTimeStampUpdated() {
        return (this.bits & 0x20) != 0;
    }

    public void setTimeStampApplied(boolean isTimeStampUpdated) {
        this.bits |= 0x20;
    }

    public boolean isGatewayTag() {
        return (this.bits & 8) != 0;
    }

    public void setEntryVersion(int version) {
        this.entryVersion = version;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersion;
    }

    public void setVersionTimeStamp(long timems) {
        this.timeStamp = timems;
    }

    public void setIsGatewayTag(boolean isGateway) {
        this.bits = isGateway ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
    }

    public void setRegionVersion(long version) {
        this.regionVersionHighBytes = (short)((version & 0xFFFF00000000L) >> 32);
        this.regionVersionLowBytes = (int)(version & 0xFFFFFFFFL);
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    public void setRegionVersion(short highBytes, int lowBytes) {
        this.regionVersionHighBytes = highBytes;
        this.regionVersionLowBytes = lowBytes;
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    public void setRecorded() {
        this.bits |= 2;
    }

    public boolean isRecorded() {
        return (this.bits & 2) != 0;
    }

    public void setCanonicalIDs(DM distributionManager) {
    }

    @Override
    public T getMemberID() {
        return this.memberID;
    }

    public void setMemberID(T memberID) {
        this.memberID = memberID;
    }

    public T getPreviousMemberID() {
        return this.previousMemberID;
    }

    public void setPreviousMemberID(T previousMemberID) {
        this.bits |= 4;
        this.previousMemberID = previousMemberID;
    }

    public VersionTag setPosDup(boolean flag) {
        this.bits = flag ? (this.bits |= 1) : (this.bits &= 0xFFFFFFFE);
        return this;
    }

    public boolean isPosDup() {
        return (this.bits & 1) != 0;
    }

    public VersionTag setAllowedByResolver(boolean flag) {
        this.bits = flag ? (this.bits |= 0x40) : (this.bits &= 0xFFFFFFBF);
        return this;
    }

    public boolean isAllowedByResolver() {
        return (this.bits & 0x40) != 0;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setDistributedSystemId(int id) {
        this.distributedSystemId = (byte)(id & 0xFF);
    }

    public void replaceNullIDs(VersionSource id) {
        if (this.memberID == null) {
            this.memberID = id;
        }
        if (this.previousMemberID == null && this.hasPreviousMemberID() && this.entryVersion > 1) {
            this.previousMemberID = id;
        }
    }

    public boolean hasPreviousMemberID() {
        return (this.bits & 4) != 0;
    }

    public boolean hasValidVersion() {
        return this.entryVersion != 0 || this.regionVersionHighBytes != 0 || this.regionVersionLowBytes != 0;
    }

    public VersionTag() {
    }

    public VersionTag(long timestamp, int dsid) {
        this.timeStamp = timestamp;
        this.distributedSystemId = (byte)(dsid & 0xFF);
        this.bits = 24;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toData(out, true);
    }

    public void toData(DataOutput out, boolean includeMember) throws IOException {
        int flags = 0;
        boolean versionIsShort = false;
        if (this.entryVersion < 65536) {
            versionIsShort = true;
            flags |= 4;
        }
        if (this.regionVersionHighBytes != 0) {
            flags |= 0x10;
        }
        if (this.memberID != null && includeMember) {
            flags |= 1;
        }
        if (this.previousMemberID != null) {
            flags |= 2;
            if (this.previousMemberID == this.memberID && includeMember) {
                flags |= 8;
            }
        }
        if (logger.isTraceEnabled(LogMarker.VERSION_TAG)) {
            logger.info(LogMarker.VERSION_TAG, "serializing {} with flags 0x{}", new Object[]{this.getClass(), Integer.toHexString(flags)});
        }
        out.writeShort(flags);
        out.writeShort(this.bits);
        out.write(this.distributedSystemId);
        if (versionIsShort) {
            out.writeShort(this.entryVersion & 0xFFFF);
        } else {
            out.writeInt(this.entryVersion);
        }
        if (this.regionVersionHighBytes != 0) {
            out.writeShort(this.regionVersionHighBytes);
        }
        out.writeInt(this.regionVersionLowBytes);
        InternalDataSerializer.writeUnsignedVL(this.timeStamp, out);
        if (this.memberID != null && includeMember) {
            this.writeMember(this.memberID, out);
        }
        if (!(this.previousMemberID == null || this.previousMemberID == this.memberID && includeMember)) {
            this.writeMember(this.previousMemberID, out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int flags = in.readUnsignedShort();
        if (logger.isTraceEnabled(LogMarker.VERSION_TAG)) {
            logger.info(LogMarker.VERSION_TAG, "deserializing {} with flags 0x{}", new Object[]{this.getClass(), Integer.toHexString(flags)});
        }
        this.bits = in.readUnsignedShort();
        this.distributedSystemId = in.readByte();
        this.entryVersion = (flags & 4) != 0 ? in.readShort() & 0xFFFF : in.readInt() & 0xFFFFFFFF;
        if ((flags & 0x10) != 0) {
            this.regionVersionHighBytes = in.readShort();
        }
        this.regionVersionLowBytes = in.readInt();
        this.timeStamp = InternalDataSerializer.readUnsignedVL(in);
        if ((flags & 1) != 0) {
            this.memberID = this.readMember(in);
        }
        if ((flags & 2) != 0) {
            this.previousMemberID = (flags & 8) != 0 ? this.memberID : this.readMember(in);
        }
        this.bits |= 0x10;
    }

    public void setIsRemoteForTesting() {
        this.bits |= 0x10;
    }

    public abstract T readMember(DataInput var1) throws IOException, ClassNotFoundException;

    public abstract void writeMember(T var1, DataOutput var2) throws IOException;

    public int getSizeInBytes() {
        int size = 8 + TAG_SIZE;
        return size += this.memberID.getSizeInBytes();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.isGatewayTag()) {
            s.append("{ds=").append(this.distributedSystemId).append("; time=").append(this.getVersionTimeStamp()).append("}");
        } else {
            s.append("{v").append(this.entryVersion);
            s.append("; rv").append(this.getRegionVersion());
            if (this.memberID != null) {
                s.append("; mbr=").append(this.memberID);
            }
            if ((this.bits & 4) != 0) {
                s.append("; prev=").append(this.previousMemberID);
            }
            if (this.distributedSystemId >= 0) {
                s.append("; ds=").append(this.distributedSystemId);
            }
            s.append("; time=").append(this.getVersionTimeStamp());
            if ((this.bits & 0x10) != 0) {
                s.append("; remote");
            }
            if (this.isAllowedByResolver()) {
                s.append("; allowed");
            }
            s.append("}");
        }
        return s.toString();
    }

    @Override
    public long getVersionTimeStamp() {
        return this.timeStamp;
    }

    public static VersionTag create(VersionSource memberId) {
        VersionTag tag = memberId instanceof DiskStoreID ? new DiskVersionTag() : new VMVersionTag();
        tag.setMemberID(memberId);
        return tag;
    }

    public static VersionTag create(boolean persistent, DataInput in) throws IOException, ClassNotFoundException {
        VersionTag tag = persistent ? new DiskVersionTag() : new VMVersionTag();
        InternalDataSerializer.invokeFromData(tag, in);
        return tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entryVersion;
        result = 31 * result + (this.memberID == null ? 0 : this.memberID.hashCode());
        result = 31 * result + this.regionVersionHighBytes;
        result = 31 * result + this.regionVersionLowBytes;
        if (this.isGatewayTag()) {
            result = 31 * result + (int)this.timeStamp;
            result = 31 * result + (int)(this.timeStamp >>> 32);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionTag other = (VersionTag)obj;
        if (this.entryVersion != other.entryVersion) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        if (this.regionVersionHighBytes != other.regionVersionHighBytes) {
            return false;
        }
        if (this.regionVersionLowBytes != other.regionVersionLowBytes) {
            return false;
        }
        if (this.isGatewayTag() != other.isGatewayTag()) {
            return false;
        }
        if (this.isGatewayTag()) {
            if (this.timeStamp != other.timeStamp) {
                return false;
            }
            if (this.distributedSystemId != other.distributedSystemId) {
                return false;
            }
        }
        return true;
    }
}

