/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tx;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.RemoteContainsKeyValueMessage;
import com.gemstone.gemfire.internal.cache.RemoteDestroyMessage;
import com.gemstone.gemfire.internal.cache.RemoteFetchEntryMessage;
import com.gemstone.gemfire.internal.cache.RemoteGetMessage;
import com.gemstone.gemfire.internal.cache.RemoteInvalidateMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemotePutAllMessage;
import com.gemstone.gemfire.internal.cache.RemotePutMessage;
import com.gemstone.gemfire.internal.cache.RemoteRemoveAllMessage;
import com.gemstone.gemfire.internal.cache.TXStateStub;
import com.gemstone.gemfire.internal.cache.partitioned.RemoteSizeMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.tx.AbstractPeerTXRegionStub;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collections;

public class DistributedTXRegionStub
extends AbstractPeerTXRegionStub {
    private final LocalRegion region;

    public DistributedTXRegionStub(TXStateStub txstate, LocalRegion r) {
        super(txstate, r);
        this.region = r;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        try {
            RemoteDestroyMessage.RemoteDestroyReplyProcessor response = RemoteDestroyMessage.send(this.state.getTarget(), event.getLocalRegion(), event, expectedOldValue, 78, true, false);
            response.waitForCacheException();
        }
        catch (EntryNotFoundException enfe) {
            throw enfe;
        }
        catch (TransactionDataNotColocatedException enfe) {
            throw enfe;
        }
        catch (CacheException ce) {
            throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_DESTROY_OF_ENTRY_ON_0_FAILED.toLocalizedString(this.state.getTarget()), ce);
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, boolean allowTombstone) {
        try {
            RemoteFetchEntryMessage.FetchEntryResponse res = RemoteFetchEntryMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey());
            return res.waitForResponse();
        }
        catch (EntryNotFoundException enfe) {
            return null;
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (TransactionException e) {
            TransactionDataNotColocatedException re = new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(keyInfo.getKey()));
            re.initCause(e);
            throw re;
        }
        catch (RemoteOperationException e) {
            throw new TransactionDataNodeHasDepartedException(e);
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        try {
            RemoteInvalidateMessage.InvalidateResponse response = RemoteInvalidateMessage.send(this.state.getTarget(), event.getRegion(), event, 78, true, false);
            response.waitForCacheException();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo) {
        try {
            RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse response = RemoteContainsKeyValueMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey(), false);
            return response.waitForContainsResult();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo) {
        try {
            RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse response = RemoteContainsKeyValueMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey(), true);
            return response.waitForContainsResult();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public Object findObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object value, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean allowReadFromHDFS) {
        Object retVal = null;
        Object key = keyInfo.getKey();
        Object callbackArgument = keyInfo.getCallbackArg();
        try {
            RemoteGetMessage.RemoteGetResponse response = RemoteGetMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, key, callbackArgument, requestingClient);
            retVal = response.waitForResponse(preferCD);
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
        return retVal;
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, boolean allowTombstone) {
        return this.getEntry(keyInfo, allowTombstone);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        boolean retVal = false;
        LocalRegion r = event.getLocalRegion();
        try {
            RemotePutMessage.RemotePutResponse response = RemotePutMessage.txSend(this.state.getTarget(), r, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
            RemotePutMessage.PutResult result = response.waitForResult();
            event.setOldValue(result.oldValue, true);
            retVal = result.returnValue;
        }
        catch (TransactionDataNotColocatedException enfe) {
            throw enfe;
        }
        catch (CacheException ce) {
            throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_DESTROY_OF_ENTRY_ON_0_FAILED.toLocalizedString(this.state.getTarget()), ce);
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
        return retVal;
    }

    @Override
    public int entryCount() {
        try {
            RemoteSizeMessage.SizeResponse response = RemoteSizeMessage.send(Collections.singleton(this.state.getTarget()), this.region);
            return response.waitForSize();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion region) {
        try {
            RemotePutAllMessage.PutAllResponse response = RemotePutAllMessage.send(this.state.getTarget(), putallOp.getBaseEvent(), putallOp.getPutAllEntryData(), putallOp.getPutAllEntryData().length, true, 78, false);
            response.waitForCacheException();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion region) {
        try {
            RemoteRemoveAllMessage.RemoveAllResponse response = RemoteRemoveAllMessage.send(this.state.getTarget(), op.getBaseEvent(), op.getRemoveAllEntryData(), op.getRemoveAllEntryData().length, true, 78, false);
            response.waitForCacheException();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public void cleanup() {
    }
}

