/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.operations.RemoveAllOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class RemoveAll
extends BaseCommand {
    private static final RemoveAll singleton = new RemoveAll();

    public static Command getCommand() {
        return singleton;
    }

    protected RemoveAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startp) throws IOException, InterruptedException {
        long start = startp;
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key = null;
        Part eventPart = null;
        boolean replyWithMetaData = false;
        VersionedObjectList response = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadRemoveAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr;
            AuthorizeRequest authzRequest;
            regionNamePart = msg.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String txt = LocalizedStrings.RemoveAll_THE_INPUT_REGION_NAME_FOR_THE_REMOVEALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.TWO_ARG_COLON, new Object[]{servConn.getName(), txt}));
                errMessage.append(txt);
                RemoveAll.writeChunkedErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during removeAll request";
                RemoveAll.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            eventPart = msg.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
            Breadcrumbs.setEventId(eventId);
            int flags = msg.getPart(2).getInt();
            boolean clientIsEmpty = (flags & 1) != 0;
            boolean clientHasCCEnabled = (flags & 2) != 0;
            Object callbackArg = msg.getPart(3).getObject();
            numberOfKeysPart = msg.getPart(4);
            numberOfKeys = numberOfKeysPart.getInt();
            if (logger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(servConn.getName()).append(": Received removeAll request from ").append(servConn.getSocketString()).append(" for region ").append(regionName).append(callbackArg != null ? " callbackArg " + callbackArg : "").append(" with ").append(numberOfKeys).append(" keys.");
                logger.debug((Object)buffer);
            }
            ArrayList<Object> keys = new ArrayList<Object>(numberOfKeys);
            ArrayList<VersionTag> retryVersions = new ArrayList<VersionTag>(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                keyPart = msg.getPart(5 + i);
                key = keyPart.getStringOrObject();
                if (key == null) {
                    String txt = LocalizedStrings.RemoveAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_REMOVEALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.TWO_ARG_COLON, new Object[]{servConn.getName(), txt}));
                    errMessage.append(txt);
                    RemoveAll.writeChunkedErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                if (msg.isRetry()) {
                    EventID entryEventId = new EventID(eventId, i);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr2 = (PartitionedRegion)region;
                        int bucketId = pr2.getKeyInfo(key).getBucketId();
                        long entryThreadId = ThreadIdentifier.createFakeThreadIDForBulkOp(bucketId, entryEventId.getThreadID());
                        entryEventId = new EventID(entryEventId.getMembershipID(), entryThreadId, entryEventId.getSequenceID());
                    }
                    VersionTag tag = this.findVersionTagsForRetriedBulkOp(region, entryEventId);
                    retryVersions.add(tag);
                } else {
                    retryVersions.add(null);
                }
                keys.add(key);
            }
            if (msg.getNumberOfParts() == 5 + numberOfKeys + 1) {
                int timeout = msg.getPart(5 + numberOfKeys).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
            if ((authzRequest = servConn.getAuthzRequest()) != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    RemoveAllOperationContext removeAllContext = authzRequest.removeAllAuthorize(regionName, keys, callbackArg);
                    callbackArg = removeAllContext.getCallbackArg();
                }
            }
            response = region.basicBridgeRemoveAll(keys, retryVersions, servConn.getProxyID(), eventId, callbackArg);
            if (!region.getConcurrencyChecksEnabled() || clientIsEmpty || !clientHasCCEnabled) {
                if (logger.isTraceEnabled()) {
                    logger.trace("setting removeAll response to null. region-cc-enabled={}; clientIsEmpty={}; client-cc-enabled={}", new Object[]{region.getConcurrencyChecksEnabled(), clientIsEmpty, clientHasCCEnabled});
                }
                response = null;
            }
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).isNetworkHop() != 0) {
                this.writeReplyWithRefreshMetadata(msg, response, servConn, pr, pr.isNetworkHop());
                pr.setIsNetworkHop((byte)0);
                pr.setMetadataVersion((byte)0);
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            RemoveAll.writeChunkedException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            RemoveAll.writeChunkedException(msg, re, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            RemoveAll.writeChunkedException(msg, pre, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            RemoveAll.checkForInterrupt(servConn, ce);
            RemoveAll.writeChunkedException(msg, ce, false, servConn);
            servConn.setAsTrue(1);
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessRemoveAllTime(start - oldStart2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending removeAll response back to {} for region {}{}", new Object[]{servConn.getName(), servConn.getSocketString(), regionName, logger.isTraceEnabled() ? ": " + response : ""});
        }
        if (!replyWithMetaData) {
            this.writeReply(msg, response, servConn);
        }
        servConn.setAsTrue(1);
        stats.incWriteRemoveAllResponseTime(DistributionStats.getStatTime() - start);
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReply(Message origMsg, VersionedObjectList response, ServerConnection servConn) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        int n = listSize = response == null ? 0 : response.size();
        if (response != null) {
            response.setKeys(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header.  version list size={}{}", new Object[]{listSize, logger.isTraceEnabled() ? " list=" + response : ""});
        }
        replyMsg.sendHeader();
        if (listSize > 0) {
            int chunkSize = 2 * maximumChunkSize;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", new Object[]{i, lastChunk, replyMsg.getNumberOfParts()});
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("sending only header");
            }
            replyMsg.addObjPart(null);
            replyMsg.setLastChunk(true);
            replyMsg.sendChunk(servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", new Object[]{servConn.getName(), origMsg.getTransactionId()});
        }
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeReplyWithRefreshMetadata(Message origMsg, VersionedObjectList response, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.sendHeader();
        int n = listSize = response == null ? 0 : response.size();
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header with metadata refresh status. Version list size = {}{}", new Object[]{listSize, logger.isTraceEnabled() ? "; list=" + response : ""});
        }
        if (response != null) {
            response.setKeys(null);
        }
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        if (listSize > 0) {
            replyMsg.setLastChunk(false);
            replyMsg.sendChunk(servConn);
            int chunkSize = 2 * maximumChunkSize;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", new Object[]{i, lastChunk, replyMsg.getNumberOfParts()});
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            replyMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("sending first and only part of chunked message");
            }
            replyMsg.sendChunk(servConn);
        }
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", new Object[]{servConn.getName(), origMsg.getTransactionId()});
        }
    }
}

