/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.operations.RegisterInterestOperationContext;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;

public class RegisterInterest
extends BaseCommand {
    private static final RegisterInterest singleton = new RegisterInterest();

    public static Command getCommand() {
        return singleton;
    }

    private RegisterInterest() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        InterestResultPolicy policy = null;
        int interestType2 = msg.getPart(1).getInt();
        try {
            policy = (InterestResultPolicy)msg.getPart(2).getObject();
        }
        catch (Exception e) {
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = msg.getPart(3);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        keyPart = msg.getPart(4);
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            RegisterInterest.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean sendUpdatesAsInvalidates = false;
        if (msg.getNumberOfParts() > 5) {
            try {
                Part notifyPart = msg.getPart(5);
                byte[] notifyPartBytes = (byte[])notifyPart.getObject();
                sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
            }
            catch (Exception e) {
                RegisterInterest.writeChunkedException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest request ({} bytes) from {} for region {} key {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key});
        }
        if (key == null || regionName == null) {
            StringId message = null;
            if (key == null) {
                message = LocalizedStrings.RegisterInterest_THE_INPUT_KEY_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            if (regionName == null) {
                message = LocalizedStrings.RegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            logger.warn("{}: {}", new Object[]{servConn.getName(), message.toLocalizedString()});
            RegisterInterest.writeChunkedErrorResponse(msg, 21, message.toLocalizedString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RegisterInterest_0_REGION_NAMED_1_WAS_NOT_FOUND_DURING_REGISTER_INTEREST_REQUEST, new Object[]{servConn.getName(), regionName}));
            }
            try {
                AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    RegisterInterestOperationContext registerContext = authzRequest.registerInterestAuthorize(regionName, key, interestType2, policy);
                    key = registerContext.getKey();
                }
                servConn.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, key, servConn.getProxyID(), interestType2, isDurable, sendUpdatesAsInvalidates, false, 0, true);
            }
            catch (Exception e) {
                RegisterInterest.checkForInterrupt(servConn, e);
                RegisterInterest.writeChunkedException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            CacheClientProxy ccp = servConn.getAcceptor().getCacheClientNotifier().getClientProxy(servConn.getProxyID());
            if (ccp == null) {
                IOException ioex = new IOException(LocalizedStrings.RegisterInterest_CACHECLIENTPROXY_FOR_THIS_CLIENT_IS_NO_LONGER_ON_THE_SERVER_SO_REGISTERINTEREST_OPERATION_IS_UNSUCCESSFUL.toLocalizedString());
                RegisterInterest.writeChunkedException(msg, ioex, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            boolean isPrimary = ccp.isPrimary();
            ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
            if (!isPrimary) {
                chunkedResponseMsg.setMessageType(33);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                chunkedResponseMsg.setLastChunk(true);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", new Object[]{servConn.getName(), regionName, key, chunkedResponseMsg});
                }
                chunkedResponseMsg.sendChunk(servConn);
            } else {
                chunkedResponseMsg.setMessageType(32);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                try {
                    RegisterInterest.fillAndSendRegisterInterestResponseChunks(region, key, interestType2, policy, servConn);
                    servConn.setAsTrue(1);
                }
                catch (Exception e) {
                    RegisterInterest.writeChunkedException(msg, e, false, servConn, chunkedResponseMsg);
                    servConn.setAsTrue(1);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent register interest response for region {} key {}", new Object[]{servConn.getName(), regionName, key});
                }
            }
        }
    }
}

