/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientInstantiatorMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RegisterInstantiators
extends BaseCommand {
    private static final RegisterInstantiators singleton = new RegisterInstantiators();

    public static Command getCommand() {
        return singleton;
    }

    private RegisterInstantiators() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        int noOfParts;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register instantiator request ({} parts) from {}", new Object[]{servConn.getName(), msg.getNumberOfParts(), servConn.getSocketString()});
        }
        Assert.assertTrue(((noOfParts = msg.getNumberOfParts()) - 1) % 3 == 0);
        int noOfInstantiators = (noOfParts - 1) / 3;
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(msg.getPart(noOfParts - 1).getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
        byte[][] serializedInstantiators = new byte[noOfInstantiators * 3][];
        boolean caughtCNFE = false;
        ClassNotFoundException cnfe = null;
        try {
            for (int i = 0; i < noOfParts - 1; i += 3) {
                Part instantiatorPart = msg.getPart(i);
                serializedInstantiators[i] = instantiatorPart.getSerializedForm();
                String instantiatorClassName = (String)CacheServerHelper.deserialize(serializedInstantiators[i]);
                Part instantiatedPart = msg.getPart(i + 1);
                serializedInstantiators[i + 1] = instantiatedPart.getSerializedForm();
                String instantiatedClassName = (String)CacheServerHelper.deserialize(serializedInstantiators[i + 1]);
                Part idPart = msg.getPart(i + 2);
                serializedInstantiators[i + 2] = idPart.getSerializedForm();
                int id = idPart.getInt();
                Class<?> instantiatorClass = null;
                Class<?> instantiatedClass = null;
                try {
                    instantiatorClass = InternalDataSerializer.getCachedClass(instantiatorClassName);
                    instantiatedClass = InternalDataSerializer.getCachedClass(instantiatedClassName);
                    InternalInstantiator.register(instantiatorClass, instantiatedClass, id, true, eventId, servConn.getProxyID());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    caughtCNFE = true;
                    cnfe = e;
                }
            }
        }
        catch (Exception e) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.RegisterInstantiators_BAD_CLIENT, new Object[]{servConn.getMembershipID(), e.getLocalizedMessage()}));
            RegisterInstantiators.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
        }
        if (caughtCNFE) {
            RegisterInstantiators.writeException(msg, cnfe, false, servConn);
            servConn.setAsTrue(1);
            ClientInstantiatorMessage clientInstantiatorMessage = new ClientInstantiatorMessage(EnumListenerEvent.AFTER_REGISTER_INSTANTIATOR, serializedInstantiators, servConn.getProxyID(), eventId);
            CacheClientNotifier.routeClientMessage(clientInstantiatorMessage);
        }
        if (!servConn.getTransientFlag(1)) {
            this.writeReply(msg, servConn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Registered instantiators for MembershipId = {}", new Object[]{servConn.getMembershipID()});
        }
    }
}

