/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.operations.PutAllOperationContext;
import com.gemstone.gemfire.cache.operations.internal.UpdateOnlyMap;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class PutAll70
extends BaseCommand {
    private static final PutAll70 singleton = new PutAll70();

    public static Command getCommand() {
        return singleton;
    }

    private PutAll70() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startp) throws IOException, InterruptedException {
        long start = startp;
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key = null;
        Part eventPart = null;
        boolean replyWithMetaData = false;
        VersionedObjectList response = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr;
            AuthorizeRequest authzRequest;
            regionNamePart = msg.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String putAllMsg = LocalizedStrings.PutAll_THE_INPUT_REGION_NAME_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn("{}: {}", new Object[]{servConn.getName(), putAllMsg});
                errMessage.append(putAllMsg);
                PutAll70.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                PutAll70.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            eventPart = msg.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
            Part callbacksPart = msg.getPart(2);
            boolean skipCallbacks = callbacksPart.getInt() == 1;
            numberOfKeysPart = msg.getPart(3);
            numberOfKeys = numberOfKeysPart.getInt();
            Map<Object, byte[]> map = new LinkedHashMap();
            LinkedHashMap<Object, VersionTag> retryVersions = new LinkedHashMap<Object, VersionTag>();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                keyPart = msg.getPart(4 + i * 2);
                key = keyPart.getStringOrObject();
                if (key == null) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", new Object[]{servConn.getName(), putAllMsg});
                    errMessage.append(putAllMsg);
                    PutAll70.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                valuePart = msg.getPart(4 + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_VALUES_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", new Object[]{servConn.getName(), putAllMsg});
                    errMessage.append(putAllMsg);
                    PutAll70.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object value = valuePart.isObject() ? (skipCallbacks && Token.INVALID.isSerializedValue(valuePart.getSerializedForm()) ? (Object)Token.INVALID : (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm())) : valuePart.getSerializedForm();
                if (msg.isRetry()) {
                    VersionTag tag;
                    EventID entryEventId = new EventID(eventId, i);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr2 = (PartitionedRegion)region;
                        int bucketId = pr2.getKeyInfo(key).getBucketId();
                        long entryThreadId = ThreadIdentifier.createFakeThreadIDForBulkOp(bucketId, entryEventId.getThreadID());
                        entryEventId = new EventID(entryEventId.getMembershipID(), entryThreadId, entryEventId.getSequenceID());
                    }
                    if ((tag = this.findVersionTagsForRetriedBulkOp(region, entryEventId)) != null) {
                        retryVersions.put(key, tag);
                    }
                }
                map.put(key, (byte[])value);
            }
            if (msg.getNumberOfParts() == 4 + 2 * numberOfKeys + 1) {
                int timeout = msg.getPart(4 + 2 * numberOfKeys).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
            if ((authzRequest = servConn.getAuthzRequest()) != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, null);
                    if ((map = putAllContext.getMap()) instanceof UpdateOnlyMap) {
                        map = ((UpdateOnlyMap)map).getInternalMap();
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received putAll request ({} bytes) from {} for region {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName});
            }
            response = region.basicBridgePutAll(map, retryVersions, servConn.getProxyID(), eventId, skipCallbacks, null);
            if (!region.getConcurrencyChecksEnabled()) {
                response = null;
            }
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).isNetworkHop() != 0) {
                this.writeReplyWithRefreshMetadata(msg, response, servConn, pr, pr.isNetworkHop());
                pr.setIsNetworkHop((byte)0);
                pr.setMetadataVersion((byte)0);
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            PutAll70.writeException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            PutAll70.writeException(msg, re, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            PutAll70.writeException(msg, pre, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll70.checkForInterrupt(servConn, ce);
            PutAll70.writeException(msg, ce, false, servConn);
            servConn.setAsTrue(1);
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending putAll70 response back to {} for region {}: {}", new Object[]{servConn.getName(), servConn.getSocketString(), regionName, response});
        }
        if (response != null && Version.GFE_70.compareTo(servConn.getClientVersion()) < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("setting putAll keys to null");
            }
            response.setKeys(null);
        }
        if (!replyWithMetaData) {
            this.writeReply(msg, response, servConn);
        }
        servConn.setAsTrue(1);
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReply(Message origMsg, VersionedObjectList response, ServerConnection servConn) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        if (response != null) {
            response.clearObjects();
            replyMsg.addObjPart(response);
        }
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", new Object[]{servConn.getName(), origMsg.getTransactionId()});
        }
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeReplyWithRefreshMetadata(Message origMsg, VersionedObjectList response, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        if (response != null) {
            response.clearObjects();
            replyMsg.addObjPart(response);
        }
        replyMsg.send(servConn);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", new Object[]{servConn.getName(), origMsg.getTransactionId()});
        }
    }
}

