/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.operations.PutAllOperationContext;
import com.gemstone.gemfire.cache.operations.internal.UpdateOnlyMap;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PutAll
extends BaseCommand {
    private static final PutAll singleton = new PutAll();

    public static Command getCommand() {
        return singleton;
    }

    private PutAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        boolean replyWithMetaData = false;
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr;
            AuthorizeRequest authzRequest;
            regionNamePart = msg.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String putAllMsg = LocalizedStrings.PutAll_THE_INPUT_REGION_NAME_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn("{}: {}", new Object[]{servConn.getName(), putAllMsg});
                errMessage.append(putAllMsg);
                PutAll.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                PutAll.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            eventPart = msg.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
            numberOfKeysPart = msg.getPart(2);
            numberOfKeys = numberOfKeysPart.getInt();
            Map<Object, byte[]> map = new LinkedHashMap();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                keyPart = msg.getPart(3 + i * 2);
                key = keyPart.getStringOrObject();
                if (key == null) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", new Object[]{servConn.getName(), putAllMsg});
                    errMessage.append(putAllMsg);
                    PutAll.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                valuePart = msg.getPart(3 + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_VALUES_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", new Object[]{servConn.getName(), putAllMsg});
                    errMessage.append(putAllMsg);
                    PutAll.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object value = valuePart.isObject() ? (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm()) : valuePart.getSerializedForm();
                map.put(key, (byte[])value);
            }
            if (msg.getNumberOfParts() == 3 + 2 * numberOfKeys + 1) {
                int timeout = msg.getPart(3 + 2 * numberOfKeys).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
            if ((authzRequest = servConn.getAuthzRequest()) != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, null);
                    if ((map = putAllContext.getMap()) instanceof UpdateOnlyMap) {
                        map = ((UpdateOnlyMap)map).getInternalMap();
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received putAll request ({} bytes) from {} for region {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName});
            }
            region.basicBridgePutAll(map, Collections.emptyMap(), servConn.getProxyID(), eventId, false, null);
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).isNetworkHop() != 0) {
                this.writeReplyWithRefreshMetadata(msg, servConn, pr, pr.isNetworkHop());
                pr.setIsNetworkHop((byte)0);
                pr.setMetadataVersion((byte)0);
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            PutAll.writeException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            PutAll.writeException(msg, re, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            PutAll.writeException(msg, pre, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll.checkForInterrupt(servConn, ce);
            PutAll.writeException(msg, ce, false, servConn);
            servConn.setAsTrue(1);
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (!replyWithMetaData) {
            this.writeReply(msg, servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent putAll response back to {} for region {}", new Object[]{servConn.getName(), servConn.getSocketString(), regionName});
        }
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }
}

