/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.KeySetOperationContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class KeySet
extends BaseCommand {
    private static final KeySet singleton = new KeySet();

    public static Command getCommand() {
        return singleton;
    }

    private KeySet() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        String regionName = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received key set request ({} bytes) from {} for region {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName});
        }
        if (regionName == null) {
            String message = null;
            message = LocalizedStrings.KeySet_0_THE_INPUT_REGION_NAME_FOR_THE_KEY_SET_REQUEST_IS_NULL.toLocalizedString(servConn.getName());
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.KeySet_0_THE_INPUT_REGION_NAME_FOR_THE_KEY_SET_REQUEST_IS_NULL, servConn.getName()));
            KeySet.writeKeySetErrorResponse(msg, 41, message, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.KeySet__0_WAS_NOT_FOUND_DURING_KEY_SET_REQUEST.toLocalizedString(regionName);
                KeySet.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                KeySetOperationContext keySetContext = null;
                AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                if (authzRequest != null) {
                    try {
                        keySetContext = authzRequest.keySetAuthorize(regionName);
                    }
                    catch (NotAuthorizedException ex) {
                        KeySet.writeChunkedException(msg, ex, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                }
                chunkedResponseMsg.setMessageType(1);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                try {
                    this.fillAndSendKeySetResponseChunks(region, regionName, keySetContext, servConn);
                    servConn.setAsTrue(1);
                }
                catch (Exception e) {
                    KeySet.checkForInterrupt(servConn, e);
                    KeySet.writeChunkedException(msg, e, false, servConn, servConn.getChunkedResponseMessage());
                    servConn.setAsTrue(1);
                    return;
                }
                if (isDebugEnabled) {
                    logger.debug("{}: Sent key set response for the region {}", new Object[]{servConn.getName(), regionName});
                }
            }
        }
    }

    private void fillAndSendKeySetResponseChunks(LocalRegion region, String regionName, KeySetOperationContext context, ServerConnection servConn) throws IOException {
        Set keySet = region.keys();
        KeySetOperationContext keySetContext = context;
        AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
        if (postAuthzRequest != null) {
            keySetContext = postAuthzRequest.keySetAuthorize(regionName, keySet, keySetContext);
            keySet = keySetContext.getKeySet();
        }
        ArrayList keyList = new ArrayList(maximumChunkSize);
        boolean isTraceEnabled = logger.isTraceEnabled();
        for (Object entryKey : keySet) {
            keyList.add(entryKey);
            if (isTraceEnabled) {
                logger.trace("{}: fillAndSendKeySetResponseKey <{}>; list size was {}; region: {}", new Object[]{servConn.getName(), entryKey, keyList.size(), region.getFullPath()});
            }
            if (keyList.size() != maximumChunkSize) continue;
            KeySet.sendKeySetResponseChunk(region, keyList, false, servConn);
            keyList.clear();
        }
        KeySet.sendKeySetResponseChunk(region, keyList, true, servConn);
    }

    private static void sendKeySetResponseChunk(Region region, List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} key set response chunk for region={}{}", new Object[]{servConn.getName(), lastChunk ? " last " : " ", region.getFullPath(), logger.isTraceEnabled() ? " keys=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""});
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

