/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.IOException;

public class GetPDXIdForEnum
extends BaseCommand {
    private static final GetPDXIdForEnum singleton = new GetPDXIdForEnum();

    public static Command getCommand() {
        return singleton;
    }

    private GetPDXIdForEnum() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        int enumId;
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx id for enum request ({} parts) from {}", new Object[]{servConn.getName(), msg.getNumberOfParts(), servConn.getSocketString()});
        }
        EnumInfo enumInfo = (EnumInfo)msg.getPart(0).getObject();
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            enumId = registry.defineEnum(enumInfo);
        }
        catch (Exception e) {
            GetPDXIdForEnum.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(msg.getTransactionId());
        responseMsg.addIntPart(enumId);
        responseMsg.send(servConn);
        servConn.setAsTrue(1);
    }
}

