/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;

public class GetFunctionAttribute
extends BaseCommand {
    private static final GetFunctionAttribute singleton = new GetFunctionAttribute();

    public static Command getCommand() {
        return singleton;
    }

    private GetFunctionAttribute() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        servConn.setAsTrue(2);
        String functionId = msg.getPart(0).getString();
        if (functionId == null) {
            String message = LocalizedStrings.GetFunctionAttribute_THE_INPUT_0_FOR_GET_FUNCTION_ATTRIBUTE_REQUEST_IS_NULL.toLocalizedString("functionId");
            logger.warn("{}: {}", new Object[]{servConn.getName(), message});
            this.sendError(msg, message, servConn);
            return;
        }
        Function function = FunctionService.getFunction(functionId);
        if (function == null) {
            String message = null;
            message = LocalizedStrings.GetFunctionAttribute_THE_FUNCTION_IS_NOT_REGISTERED_FOR_FUNCTION_ID_0.toLocalizedString(functionId);
            logger.warn("{}: {}", new Object[]{servConn.getName(), message});
            this.sendError(msg, message, servConn);
            return;
        }
        byte[] functionAttributes = new byte[]{(byte)(function.hasResult() ? 1 : 0), (byte)(function.isHA() ? 1 : 0), (byte)(function.optimizeForWrite() ? 1 : 0)};
        GetFunctionAttribute.writeResponseWithFunctionAttribute(functionAttributes, msg, servConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(Message msg, String message, ServerConnection servConn) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            GetFunctionAttribute.writeErrorResponse(msg, 3, message, servConn);
            servConn.setAsTrue(1);
        }
    }
}

