/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntry;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.Get70;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;

public class GetEntry70
extends Get70 {
    private static final GetEntry70 singleton = new GetEntry70();

    public static Command getCommand() {
        return singleton;
    }

    protected GetEntry70() {
    }

    @Override
    protected Get70.Entry getEntry(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        return this.getValueAndIsObject(region, key, callbackArg, servConn);
    }

    @Override
    public Get70.Entry getValueAndIsObject(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        LocalRegion lregion = (LocalRegion)region;
        EntrySnapshot data = null;
        Region.Entry entry = region.getEntry(key);
        if (logger.isDebugEnabled()) {
            logger.debug("GetEntryCommand: for key: {} returning entry: {}", new Object[]{key, entry});
        }
        VersionTag tag = null;
        if (entry != null) {
            EntrySnapshot snap = new EntrySnapshot();
            NonLocalRegionEntry re = new NonLocalRegionEntry(entry, lregion);
            snap.setRegionEntry(re);
            snap.setRegion(lregion);
            data = snap;
            tag = snap.getVersionTag();
        }
        Get70.Entry result = new Get70.Entry();
        result.value = data;
        result.isObject = true;
        result.keyNotPresent = false;
        result.versionTag = tag;
        return result;
    }
}

