/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class GetAllWithCallback
extends BaseCommand {
    private static final Logger logger = LogService.getLogger();
    private static final GetAllWithCallback singleton = new GetAllWithCallback();

    public static Command getCommand() {
        return singleton;
    }

    protected GetAllWithCallback() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keysPart = null;
        Part callbackPart = null;
        String regionName = null;
        Object[] keys = null;
        Object callback = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        int partIdx = 0;
        regionNamePart = msg.getPart(partIdx++);
        regionName = regionNamePart.getString();
        keysPart = msg.getPart(partIdx++);
        try {
            keys = (Object[])keysPart.getObject();
        }
        catch (Exception e) {
            GetAllWithCallback.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        callbackPart = msg.getPart(partIdx++);
        try {
            callback = callbackPart.getObject();
        }
        catch (Exception e) {
            GetAllWithCallback.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(servConn.getName()).append(": Received getAll request (").append(msg.getPayloadLength()).append(" bytes) from ").append(servConn.getSocketString()).append(" for region ").append(regionName).append(" with callback ").append(callback).append(" keys ");
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    buffer.append(keys[i]).append(" ");
                }
            } else {
                buffer.append("NULL");
            }
            logger.debug(buffer.toString());
        }
        if (regionName == null) {
            String message = null;
            message = LocalizedStrings.GetAll_THE_INPUT_REGION_NAME_FOR_THE_GETALL_REQUEST_IS_NULL.toLocalizedString();
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.TWO_ARG_COLON, new Object[]{servConn.getName(), message}));
            GetAllWithCallback.writeChunkedErrorResponse(msg, 58, message, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during getAll request";
                GetAllWithCallback.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
                chunkedResponseMsg.setMessageType(1);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                try {
                    this.fillAndSendGetAllResponseChunks(region, regionName, keys, servConn, callback);
                    servConn.setAsTrue(1);
                }
                catch (Exception e) {
                    GetAllWithCallback.checkForInterrupt(servConn, e);
                    GetAllWithCallback.writeChunkedException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void fillAndSendGetAllResponseChunks(Region region, String regionName, Object[] keys, ServerConnection servConn, Object callback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void sendGetAllResponseChunk(Region region, ObjectPartList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPartNoCopying(list);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} getAll response chunk for region={}{}", new Object[]{servConn.getName(), lastChunk ? " last " : " ", region.getFullPath(), logger.isTraceEnabled() ? " values=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""});
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

