/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.cache.operations.internal.GetOperationContextImpl;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;

public class Get70
extends BaseCommand {
    private static final Get70 singleton = new Get70();

    public static Command getCommand() {
        return singleton;
    }

    protected Get70() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startparam) throws IOException {
        long start = startparam;
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        StringId errMessage = null;
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadGetRequestTime(start - oldStart);
        int parts = msg.getNumberOfParts();
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        if (parts > 2) {
            valuePart = msg.getPart(2);
            try {
                callbackArg = valuePart.getObject();
            }
            catch (Exception e) {
                Get70.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Get70.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received 7.0 get request ({} bytes) from {} for region {} key {} txId {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key, msg.getTransactionId()});
        }
        if (key == null || regionName == null) {
            if (key == null && regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_AND_KEY_FOR_THE_GET_REQUEST_ARE_NULL;
            } else if (key == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_KEY_FOR_THE_GET_REQUEST_IS_NULL;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_FOR_THE_GET_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", new Object[]{servConn.getName(), s});
            Get70.writeErrorResponse(msg, 3, s, servConn);
            servConn.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Request__0_WAS_NOT_FOUND_DURING_GET_REQUEST.toLocalizedString(regionName);
                Get70.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                Object originalData;
                Entry entry;
                GetOperationContext getContext = null;
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        getContext = authzRequest.getAuthorize(regionName, key, callbackArg);
                        callbackArg = getContext.getCallbackArg();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Get70.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                try {
                    entry = this.getEntry(region, key, callbackArg, servConn);
                }
                catch (Exception e) {
                    Get70.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object data = originalData = entry.value;
                try {
                    boolean keyNotPresent;
                    VersionTag versionTag;
                    boolean isObject;
                    block44: {
                        isObject = entry.isObject;
                        versionTag = entry.versionTag;
                        keyNotPresent = entry.keyNotPresent;
                        try {
                            AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
                            if (postAuthzRequest == null) break block44;
                            try {
                                getContext = postAuthzRequest.getAuthorize(regionName, key, data, isObject, getContext);
                                GetOperationContextImpl gci = (GetOperationContextImpl)getContext;
                                Object newData = gci.getRawValue();
                                if (newData != data) {
                                    isObject = getContext.isObject();
                                    data = newData;
                                }
                            }
                            finally {
                                if (getContext != null) {
                                    ((GetOperationContextImpl)getContext).release();
                                }
                            }
                        }
                        catch (NotAuthorizedException ex) {
                            Get70.writeException(msg, ex, false, servConn);
                            servConn.setAsTrue(1);
                            OffHeapHelper.release(originalData);
                            return;
                        }
                    }
                    long oldStart2 = start;
                    start = DistributionStats.getStatTime();
                    stats.incProcessGetTime(start - oldStart2);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr = (PartitionedRegion)region;
                        if (pr.isNetworkHop() != 0) {
                            this.writeResponseWithRefreshMetadata(data, callbackArg, msg, isObject, servConn, pr, pr.isNetworkHop(), versionTag, keyNotPresent);
                            pr.setIsNetworkHop((byte)0);
                            pr.setMetadataVersion((byte)0);
                        } else {
                            this.writeResponse(data, callbackArg, msg, isObject, versionTag, keyNotPresent, servConn);
                        }
                    } else {
                        this.writeResponse(data, callbackArg, msg, isObject, versionTag, keyNotPresent, servConn);
                    }
                }
                finally {
                    OffHeapHelper.release(originalData);
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Wrote get response back to {} for region {} {}", new Object[]{servConn.getName(), servConn.getSocketString(), regionName, entry});
                }
                stats.incWriteGetResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    protected Entry getEntry(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        return this.getEntryRetained(region, key, callbackArg, servConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getValueAndIsObject(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key);
        }
        VersionTag versionTag = null;
        boolean isObject = true;
        Object data = null;
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        EntryEventImpl versionHolder = EntryEventImpl.createVersionTagHolder();
        try {
            data = ((LocalRegion)region).get(key, callbackArg, true, true, true, id, versionHolder, true, true);
        }
        finally {
            versionHolder.release();
        }
        versionTag = versionHolder.getVersionTag();
        boolean wasInvalid = false;
        if (data instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)data;
            if (!cd.isSerialized()) {
                isObject = false;
                data = cd.getDeserializedForReading();
            } else {
                data = cd.getValue();
            }
        } else if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
            wasInvalid = true;
        } else if (data instanceof byte[]) {
            isObject = false;
        }
        Entry result = new Entry();
        result.value = data;
        result.isObject = isObject;
        result.keyNotPresent = !wasInvalid && (data == null || data == Token.TOMBSTONE);
        result.versionTag = versionTag;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntryRetained(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key);
        }
        VersionTag versionTag = null;
        boolean isObject = true;
        Object data = null;
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        EntryEventImpl versionHolder = EntryEventImpl.createVersionTagHolder();
        try {
            data = ((LocalRegion)region).getRetained(key, callbackArg, true, true, id, versionHolder, true);
        }
        finally {
            versionHolder.release();
        }
        versionTag = versionHolder.getVersionTag();
        boolean wasInvalid = false;
        if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
            wasInvalid = true;
        } else if (data instanceof byte[]) {
            isObject = false;
        } else if (data instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)data;
            isObject = cd.isSerialized();
            if (cd.usesHeapForStorage()) {
                data = cd.getValue();
            }
        }
        Entry result = new Entry();
        result.value = data;
        result.isObject = isObject;
        result.keyNotPresent = !wasInvalid && (data == null || data == Token.TOMBSTONE);
        result.versionTag = versionTag;
        return result;
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, VersionTag versionTag, boolean keyNotPresent, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        int numParts = 2;
        int flags = 0;
        if (callbackArg != null) {
            ++numParts;
            flags |= 1;
        }
        if (versionTag != null) {
            ++numParts;
            flags |= 2;
        }
        if (keyNotPresent) {
            flags |= 4;
        } else if (data == null && isObject) {
            flags |= 8;
        }
        responseMsg.setNumberOfParts(numParts);
        responseMsg.addPartInAnyForm(data, isObject);
        responseMsg.addIntPart(flags);
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        if (versionTag != null) {
            responseMsg.addObjPart(versionTag);
        }
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    protected static void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeResponseWithRefreshMetadata(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn, PartitionedRegion pr, byte nwHop, VersionTag versionTag, boolean keyNotPresent) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        int numParts = 3;
        int flags = 0;
        if (callbackArg != null) {
            ++numParts;
            flags |= 1;
        }
        if (versionTag != null) {
            ++numParts;
            flags |= 2;
        }
        if (keyNotPresent) {
            flags |= 4;
        } else if (data == null && isObject) {
            flags |= 8;
        }
        responseMsg.setNumberOfParts(numParts);
        responseMsg.addPartInAnyForm(data, isObject);
        responseMsg.addIntPart(flags);
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        if (versionTag != null) {
            responseMsg.addObjPart(versionTag);
        }
        responseMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    public static class Entry {
        public Object value;
        public boolean isObject;
        public boolean keyNotPresent;
        public VersionTag versionTag;

        public String toString() {
            return "value=" + this.value + " isObject=" + this.isObject + " notPresent=" + this.keyNotPresent + " version=" + this.versionTag;
        }
    }
}

