/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.operations.RegionDestroyOperationContext;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DestroyRegion
extends BaseCommand {
    private static final DestroyRegion singleton = new DestroyRegion();

    public static Command getCommand() {
        return singleton;
    }

    private DestroyRegion() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadDestroyRegionRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        eventPart = msg.getPart(1);
        if (msg.getNumberOfParts() > 2) {
            callbackArgPart = msg.getPart(2);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (DistributedSystemDisconnectedException se) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", new Object[]{servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getProxyID()});
                }
                servConn.setFlagProcessMessagesAsFalse();
                return;
            }
            catch (Exception e) {
                DestroyRegion.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy region request ({} bytes) from {} for region {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName});
        }
        if (regionName == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.DestroyRegion_0_THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REGION_REQUEST_IS_NULL, servConn.getName()));
            errMessage.append(LocalizedStrings.DestroyRegion__THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REGION_REQUEST_IS_NULL.toLocalizedString());
            DestroyRegion.writeErrorResponse(msg, 12, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.DestroyRegion_REGION_WAS_NOT_FOUND_DURING_DESTROY_REGION_REQUEST.toLocalizedString();
                DestroyRegion.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize(regionName, callbackArg);
                        callbackArg = destroyContext.getCallbackArg();
                    }
                    region.basicBridgeDestroyRegion(callbackArg, servConn.getProxyID(), true, eventId);
                }
                catch (DistributedSystemDisconnectedException e) {
                    if (servConn.getCachedRegionHelper().getCache().getCancelCriterion().cancelInProgress() != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", new Object[]{servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getProxyID()});
                        }
                        servConn.setFlagProcessMessagesAsFalse();
                    } else {
                        DestroyRegion.writeException(msg, e, false, servConn);
                        servConn.setAsTrue(1);
                    }
                    return;
                }
                catch (Exception e) {
                    DestroyRegion.checkForInterrupt(servConn, e);
                    DestroyRegion.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessDestroyRegionTime(start - oldStart2);
                this.writeReply(msg, servConn);
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent destroy region response for region {}", new Object[]{servConn.getName(), regionName});
                }
                stats.incWriteDestroyRegionResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }
}

